/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;

public class ResourceVisitorVerifier
implements IResourceVisitor {
    Set<IResource> expected;
    StringBuilder message;
    boolean success = true;
    boolean verified = false;

    public ResourceVisitorVerifier() {
        this.reset();
    }

    public void addExpected(IResource resource) {
        this.expected.add(resource);
    }

    public void addExpected(IResource[] resources) {
        this.expected.addAll(Arrays.asList(resources));
    }

    public boolean visit(IResource resource) {
        boolean included = this.expected.remove(resource);
        if (!included) {
            this.success = false;
            this.log(String.valueOf(resource.getFullPath()) + " was not expected.");
        }
        return true;
    }

    private void log(String text) {
        this.message.append("\n" + text);
    }

    private void verify() {
        if (this.verified) {
            return;
        }
        for (IResource resource : this.expected) {
            this.success = false;
            this.log(String.valueOf(resource.getFullPath()) + " was not visited.");
        }
        this.verified = true;
    }

    public boolean isValid() {
        this.verify();
        return this.success;
    }

    public String getMessage() {
        return this.message.toString();
    }

    public void reset() {
        this.expected = new HashSet<IResource>();
        this.message = new StringBuilder();
        this.verified = false;
    }
}

