/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.ResourceVisitorVerifier;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TeamPrivateMemberTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Test
    public void testRefreshLocal() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceDeltaVerifier listener = new ResourceDeltaVerifier();
        listener.addExpectedChange((IResource)subFile, 4, 256);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            this.setTeamPrivateMember((IResource)folder, true, 0);
            ResourceTestUtil.ensureOutOfSync(subFile);
            project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    @Test
    public void testFindMember() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        Assertions.assertThat((Object)root.findMember(project.getFullPath())).isEqualTo((Object)project);
        Assertions.assertThat((Object)root.findMember(folder.getFullPath())).isEqualTo((Object)folder);
        Assertions.assertThat((Object)root.findMember(file.getFullPath())).isEqualTo((Object)file);
        Assertions.assertThat((Object)root.findMember(subFile.getFullPath())).isEqualTo((Object)subFile);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        Assertions.assertThat((Object)root.findMember(project.getFullPath())).isEqualTo((Object)project);
        Assertions.assertThat((Object)root.findMember(folder.getFullPath())).isEqualTo((Object)folder);
        Assertions.assertThat((Object)root.findMember(file.getFullPath())).isEqualTo((Object)file);
        Assertions.assertThat((Object)root.findMember(subFile.getFullPath())).isEqualTo((Object)subFile);
        this.setTeamPrivateMember((IResource)project, true, 2);
        Assertions.assertThat((Object)root.findMember(project.getFullPath())).isEqualTo((Object)project);
        Assertions.assertThat((Object)root.findMember(folder.getFullPath())).isEqualTo((Object)folder);
        Assertions.assertThat((Object)root.findMember(file.getFullPath())).isEqualTo((Object)file);
        Assertions.assertThat((Object)root.findMember(subFile.getFullPath())).isEqualTo((Object)subFile);
    }

    @Test
    public void testMembers() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        IResource[] resources = new IResource[]{project, folder, file, subFile, settings, prefs};
        ResourceTestUtil.createInWorkspace(resources);
        this.assertTeamPrivateMember((IResource)project, false, 2);
        Assertions.assertThat((Object[])project.members()).hasSize(4);
        Assertions.assertThat((Object[])folder.members()).hasSize(1);
        this.setTeamPrivateMember((IResource)project, true, 2);
        this.assertTeamPrivateMember((IResource)project, true, 2);
        this.assertTeamPrivateMember((IResource)project, true, 2);
        Assertions.assertThat((Object[])project.members()).hasSize(0);
        Assertions.assertThat((Object[])folder.members()).hasSize(0);
        this.setTeamPrivateMember((IResource)project, false, 2);
        this.assertTeamPrivateMember((IResource)project, false, 2);
        Assertions.assertThat((Object[])project.members(0)).hasSize(4);
        Assertions.assertThat((Object[])project.members(2)).hasSize(4);
        Assertions.assertThat((Object[])folder.members()).hasSize(1);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        Assertions.assertThat((Object[])project.members()).hasSize(3);
        Assertions.assertThat((Object[])folder.members()).hasSize(1);
        Assertions.assertThat((Object[])project.members(0)).hasSize(3);
        Assertions.assertThat((Object[])folder.members()).hasSize(1);
        Assertions.assertThat((Object[])project.members(2)).hasSize(4);
        Assertions.assertThat((Object[])folder.members()).hasSize(1);
        this.setTeamPrivateMember((IResource)project, true, 2);
        this.assertTeamPrivateMember((IResource)project, true, 2);
        Assertions.assertThat((Object[])project.members(0)).hasSize(0);
        Assertions.assertThat((Object[])folder.members(0)).hasSize(0);
        Assertions.assertThat((Object[])project.members(2)).hasSize(4);
        Assertions.assertThat((Object[])folder.members(2)).hasSize(1);
    }

    @Test
    public void testAccept() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        IResource[] resources = new IResource[]{project, folder, file, subFile, settings, prefs};
        ResourceTestUtil.createInWorkspace(resources);
        IFile description = project.getFile(".project");
        ResourceVisitorVerifier visitor = new ResourceVisitorVerifier();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 2);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        this.setTeamPrivateMember((IResource)folder, true, 0);
        visitor.reset();
        visitor.addExpected((IResource)project);
        visitor.addExpected((IResource)file);
        visitor.addExpected((IResource)description);
        visitor.addExpected((IResource)settings);
        visitor.addExpected((IResource)prefs);
        project.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)project);
        visitor.addExpected((IResource)file);
        visitor.addExpected((IResource)description);
        visitor.addExpected((IResource)settings);
        visitor.addExpected((IResource)prefs);
        project.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 2);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        folder.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        folder.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)folder);
        visitor.addExpected((IResource)subFile);
        folder.accept((IResourceVisitor)visitor, 2, 2);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        this.setTeamPrivateMember((IResource)project, true, 2);
        this.assertTeamPrivateMember((IResource)project, true, 2);
        visitor.reset();
        visitor.addExpected((IResource)project);
        project.accept((IResourceVisitor)visitor);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected((IResource)project);
        project.accept((IResourceVisitor)visitor, 2, 0);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
        visitor.reset();
        visitor.addExpected(resources);
        visitor.addExpected((IResource)description);
        project.accept((IResourceVisitor)visitor, 2, 2);
        Assert.assertTrue((String)visitor.getMessage(), (boolean)visitor.isValid());
    }

    @Test
    public void testCopy() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        IProject destProject = root.getProject("MyOtherProject");
        IFolder destFolder = destProject.getFolder(folder.getName());
        IFile destFile = destProject.getFile(file.getName());
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IResource[] destResources = new IResource[]{destProject, destFolder, destFile, destSubFile};
        ResourceTestUtil.removeFromWorkspace(destResources);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        int flags = 1;
        project.copy(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        folder.copy(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)project, true, 2);
        project.copy(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setTeamPrivateMember((IResource)project, true, 2);
        folder.copy(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
    }

    @Test
    public void testMove() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        IProject destProject = root.getProject("MyOtherProject");
        IFolder destFolder = destProject.getFolder(folder.getName());
        IFile destFile = destProject.getFile(file.getName());
        IFile destSubFile = destFolder.getFile(subFile.getName());
        IResource[] destResources = new IResource[]{destProject, destFolder, destFile, destSubFile};
        ResourceTestUtil.removeFromWorkspace(destResources);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        int flags = 1;
        project.move(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        folder.move(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)project, true, 2);
        project.move(destProject.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(destResources);
        ResourceTestUtil.removeFromWorkspace(destResources);
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.createInWorkspace((IResource)destProject);
        this.setTeamPrivateMember((IResource)project, true, 2);
        folder.move(destFolder.getFullPath(), flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{destFolder, destSubFile});
    }

    @Test
    public void testDelete() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        int flags = 5;
        project.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.createInWorkspace(resources);
        file.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, folder, subFile});
        ResourceTestUtil.createInWorkspace(resources);
        folder.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        project.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        folder.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, file});
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)project, true, 2);
        project.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(resources);
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)project, true, 2);
        file.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, folder, subFile});
        ResourceTestUtil.createInWorkspace(resources);
        this.setTeamPrivateMember((IResource)project, true, 2);
        folder.delete(flags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, subFile});
        ResourceTestUtil.assertExistsInWorkspace(new IResource[]{project, file});
    }

    @Test
    public void testDeltas() throws CoreException {
        IWorkspaceRunnable body;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        IFile description = project.getFile(".project");
        IResource[] resources = new IResource[]{project, folder, file, subFile, settings, prefs};
        ResourceDeltaVerifier listener = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            body = monitor -> ResourceTestUtil.createInWorkspace(resources);
            listener.addExpectedChange(resources, 1, 0);
            listener.addExpectedChange((IResource)project, 1, 16384);
            listener.addExpectedChange((IResource)description, 1, 0);
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            ResourceTestUtil.waitForBuild();
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
            ResourceTestUtil.removeFromWorkspace(resources);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            body = monitor -> {
                ResourceTestUtil.createInWorkspace(resources);
                this.setTeamPrivateMember((IResource)folder, true, 0);
            };
            listener.reset();
            listener.addExpectedChange(resources, 1, 0);
            listener.addExpectedChange((IResource)project, 1, 16384);
            listener.addExpectedChange((IResource)description, 1, 0);
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
            ResourceTestUtil.removeFromWorkspace(resources);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        try {
            body = monitor -> {
                ResourceTestUtil.createInWorkspace(resources);
                this.setTeamPrivateMember((IResource)project, true, 2);
            };
            listener.reset();
            listener.addExpectedChange(resources, 1, 0);
            listener.addExpectedChange((IResource)project, 1, 16384);
            listener.addExpectedChange((IResource)description, 1, 0);
            ResourcesPlugin.getWorkspace().run(body, ResourceTestUtil.createTestMonitor());
            Assert.assertTrue((String)listener.getMessage(), (boolean)listener.isDeltaValid());
            ResourceTestUtil.removeFromWorkspace(resources);
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        }
    }

    @Test
    public void testExists() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] resources = new IResource[]{project, folder, file, subFile};
        ResourceTestUtil.createInWorkspace(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        this.setTeamPrivateMember((IResource)folder, true, 0);
        this.assertTeamPrivateMember((IResource)folder, true, 0);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        this.setTeamPrivateMember((IResource)project, true, 2);
        this.assertTeamPrivateMember((IResource)project, true, 2);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    @Test
    public void testSetGet() throws CoreException {
        IResource resource;
        IResource[] resources;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file.txt");
        IFile subFile = folder.getFile("subfile.txt");
        IResource[] iResourceArray = resources = new IResource[]{project, folder, file, subFile};
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            Assert.assertThrows(CoreException.class, () -> resource.setTeamPrivateMember(true));
            ++n2;
        }
        ResourceTestUtil.createInWorkspace(resources);
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            this.assertTeamPrivateMember(resource, false);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            resource.setTeamPrivateMember(true);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            IResource resource2;
            IResource resource3 = resource2 = iResourceArray[n2];
            switch (resource3.getType()) {
                case 1: 
                case 2: {
                    this.assertTeamPrivateMember(resource3, true);
                    break;
                }
                case 4: 
                case 8: {
                    this.assertTeamPrivateMember(resource3, false);
                }
            }
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            resource.setTeamPrivateMember(false);
            ++n2;
        }
        iResourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = iResourceArray[n2];
            this.assertTeamPrivateMember(resource, false);
            ++n2;
        }
    }

    private void assertTeamPrivateMember(IResource root, boolean value, int depth) throws CoreException {
        IResourceVisitor visitor = resource -> {
            boolean expected = false;
            if (resource.getType() == 1 || resource.getType() == 2) {
                expected = value;
            }
            this.assertTeamPrivateMember(resource, expected);
            return true;
        };
        root.accept(visitor, depth, 2);
    }

    private void assertTeamPrivateMember(IResource resource, boolean expectedValue) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resource.isTeamPrivateMember()).as("isTeamPrivateMember value for resource: %s", new Object[]{resource})).isEqualTo(expectedValue);
    }

    private void setTeamPrivateMember(IResource root, boolean value, int depth) throws CoreException {
        IResourceVisitor visitor = resource -> {
            resource.setTeamPrivateMember(value);
            return true;
        };
        root.accept(visitor, depth, 2);
    }
}

