/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Arrays;
import java.util.Random;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.junit.Assert;

public abstract class TestPerformer {
    private int count = 0;
    private String reasonForExpectedFail = null;

    public TestPerformer(String name) {
    }

    public void cleanUp(Object[] args, int countArg) throws Exception {
    }

    public Object[] interestingOldState(Object[] args) throws Exception {
        return null;
    }

    public abstract Object invokeMethod(Object[] var1, int var2) throws Exception;

    public final void performTest(Object[][] inputs) throws Exception {
        int permutations = 1;
        Object[][] objectArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] input = objectArray[n2];
            permutations *= input.length;
            if (input.length > 2) {
                TestPerformer.scramble(input);
            }
            ++n2;
        }
        this.performTestRecursiveLoop(inputs, new Object[inputs.length], 0);
    }

    private void performTestRecursiveLoop(Object[][] inputs, Object[] args, int nth) throws Exception {
        Object[] objectArray = inputs[nth];
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object input;
            args[nth] = input = objectArray[n2];
            if (nth == inputs.length - 1) {
                this.reasonForExpectedFail = null;
                if (this.shouldFail(args, this.count)) {
                    try {
                        this.invokeMethod(args, this.count);
                        Assert.fail((String)(this.getFailMessagePrefixForCurrentInvocation(args) + "invocation did not fail although it should" + (String)(this.reasonForExpectedFail != null ? ": " + this.reasonForExpectedFail : "")));
                    }
                    catch (Exception exception) {}
                } else {
                    Object[] oldState = null;
                    try {
                        oldState = this.interestingOldState(args);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("call to interestingOldState failed", ex);
                    }
                    Object result = null;
                    try {
                        result = this.invokeMethod(args, this.count);
                    }
                    catch (FussyProgressMonitor.FussyProgressAssertionFailed fussyEx) {
                        throw new AssertionError(this.getFailMessagePrefixForCurrentInvocation(args) + "invocation should succeed but fuzzy progress assertion failed: " + fussyEx.getMessage(), fussyEx);
                    }
                    catch (Exception ex) {
                        throw new AssertionError(this.getFailMessagePrefixForCurrentInvocation(args) + "invocation should succeed but unexpected exception occurred: " + String.valueOf(ex), ex);
                    }
                    boolean success = false;
                    try {
                        success = this.wasSuccess(args, result, oldState);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Assert.assertTrue((String)(this.getFailMessagePrefixForCurrentInvocation(args) + "invocation should succeed but did not produce desired result"), (boolean)success);
                }
                this.cleanUp(args, this.count);
                ++this.count;
            } else {
                this.performTestRecursiveLoop(inputs, args, nth + 1);
            }
            ++n2;
        }
    }

    protected void setReasonForExpectedFail(String reasonForFailing) {
        this.reasonForExpectedFail = reasonForFailing;
    }

    private String getFailMessagePrefixForCurrentInvocation(Object[] currentArgs) {
        return "failure in invocation " + this.count + " with inputs " + Arrays.toString(currentArgs) + System.lineSeparator();
    }

    protected static void scramble(Object[] first) {
        Random random = new Random(4711L);
        int len = first.length;
        int i = 0;
        while (i < len * 100) {
            int off2;
            int off1 = (int)(random.nextFloat() * (float)len);
            if (off1 != len && (off2 = (int)(random.nextFloat() * (float)len)) != len) {
                Object temp = first[off1];
                first[off1] = first[off2];
                first[off2] = temp;
            }
            ++i;
        }
    }

    public abstract boolean shouldFail(Object[] var1, int var2) throws Exception;

    public abstract boolean wasSuccess(Object[] var1, Object var2, Object[] var3) throws Exception;
}

