/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.FreezeMonitor;
import org.junit.Assert;

public class TestUtil {
    public static void cleanUp(String owner) {
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
        boolean timedOut = TestUtil.waitForJobs(owner, 5L, 5000L);
        if (timedOut) {
            TestUtil.log(1, owner, "Trying to cancel running jobs: " + String.valueOf(TestUtil.getRunningOrWaitingJobs(null)), new Throwable[0]);
            TestUtil.getRunningOrWaitingJobs(null).forEach(Job::cancel);
            TestUtil.waitForJobs(owner, 5L, 1000L);
        }
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
    }

    public static void log(int severity, String owner, String message, Throwable ... optionalError) {
        message = "[" + owner + "] " + (String)message;
        Throwable error = null;
        if (optionalError != null && optionalError.length > 0) {
            error = optionalError[0];
        }
        Status status = new Status(severity, "org.eclipse.core.tests.resources", (String)message, error);
        InternalPlatform.getDefault().getLog(Platform.getBundle((String)"org.eclipse.core.tests.resources")).log((IStatus)status);
    }

    public static boolean waitForCondition(Supplier<Boolean> condition, int timeoutInMilliseconds) {
        long timeoutInNs = (long)timeoutInMilliseconds * 1000000L;
        long startTimeInNs = System.nanoTime();
        long durationInNs = 0L;
        while (!condition.get().booleanValue() && durationInNs < timeoutInNs) {
            Thread.yield();
            durationInNs = System.nanoTime() - startTimeInNs;
        }
        return condition.get();
    }

    public static boolean waitForJobs(String owner, long minTimeMs, long maxTimeMs) {
        return TestUtil.waitForJobs(owner, minTimeMs, maxTimeMs, null);
    }

    static boolean ignoreJob(Job job) {
        if (job instanceof StringPoolJob) {
            return true;
        }
        Class<?> clazz = job.getClass();
        while ((clazz = clazz.getSuperclass()) != null) {
            if (!clazz.getSimpleName().equals("UIJob")) continue;
            return true;
        }
        return job.belongsTo(FreezeMonitor.class);
    }

    private static void wakeUpSleepingJobs(Object family) {
        List<Job> sleepingJobs = TestUtil.getSleepingJobs(family);
        for (Job job : sleepingJobs) {
            if (TestUtil.ignoreJob(job)) continue;
            job.wakeUp();
        }
    }

    public static boolean waitForJobs(String owner, long minTimeMs, long maxTimeMs, Object family) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        TestUtil.wakeUpSleepingJobs(family);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            try {
                Thread.sleep(Math.min(10L, minTimeMs));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (!Job.getJobManager().isIdle()) {
            List<Job> jobs = TestUtil.getRunningOrWaitingJobs(family);
            if (jobs.isEmpty()) break;
            long millisGone = System.currentTimeMillis() - start;
            if (millisGone >= maxTimeMs) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs, millisGone);
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TestUtil.wakeUpSleepingJobs(family);
        }
        return false;
    }

    public static void dumpRunnigOrWaitingJobs(String owner) {
        List<Job> jobs = TestUtil.getRunningOrWaitingJobs(null);
        if (!jobs.isEmpty()) {
            String message = "Some job is still running or waiting to run: " + TestUtil.asString(jobs);
            TestUtil.log(1, owner, message, new RuntimeException(message));
        }
    }

    private static void dumpRunningOrWaitingJobs(String owner, List<Job> jobs, long millisGone) {
        String message = "Some job is still running or waiting to run after " + millisGone + "ms: " + TestUtil.dumpRunningOrWaitingJobs(jobs);
        TestUtil.log(4, owner, message, new RuntimeException(message));
    }

    private static String dumpRunningOrWaitingJobs(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return "";
        }
        return TestUtil.asString(jobs);
    }

    private static String asString(Job job) {
        StringBuilder sb = new StringBuilder();
        sb.append("'").append(job.getName()).append("'/");
        sb.append(job.getClass().getName());
        sb.append(" state=" + job.getState());
        Thread thread = job.getThread();
        if (thread != null) {
            sb.append(" thread=" + thread.getName());
        }
        return sb.toString();
    }

    private static String asString(List<Job> jobs) {
        return jobs.stream().map(TestUtil::asString).collect(Collectors.joining(", "));
    }

    private static List<Job> getRunningOrWaitingJobs(Object jobFamily) {
        Job[] jobs;
        ArrayList<Job> running = new ArrayList<Job>();
        Job[] jobArray = jobs = Job.getJobManager().find(jobFamily);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (TestUtil.isRunningOrWaitingJob(job) && !TestUtil.ignoreJob(job)) {
                running.add(job);
            }
            ++n2;
        }
        return running;
    }

    private static List<Job> getSleepingJobs(Object family) {
        Job[] jobs;
        ArrayList<Job> running = new ArrayList<Job>();
        Job[] jobArray = jobs = Job.getJobManager().find(family);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getState() == 1) {
                running.add(job);
            }
            ++n2;
        }
        return running;
    }

    private static boolean isRunningOrWaitingJob(Job job) {
        int state = job.getState();
        return state == 4 || state == 2;
    }
}

