/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.InputStream;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class VirtualFolderTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    protected IProject existingProject;
    protected IFolder existingVirtualFolderInExistingProject;

    @Before
    public void setUp() throws Exception {
        this.existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ExistingProject");
        this.existingVirtualFolderInExistingProject = this.existingProject.getFolder("existingVirtualFolderInExistingProject");
        ResourceTestUtil.createInWorkspace(new IResource[]{this.existingProject});
        this.existingVirtualFolderInExistingProject.create(8192, true, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCreateVirtualFolder() throws CoreException {
        IFolder virtualFolder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        virtualFolder.create(8192, true, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)virtualFolder.exists());
        Assert.assertTrue((String)"3.0", (boolean)virtualFolder.isVirtual());
        virtualFolder.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCreateFileUnderVirtualFolder() {
        IFile file = this.existingVirtualFolderInExistingProject.getFile(ResourceTestUtil.createUniqueString());
        Assert.assertThrows(CoreException.class, () -> file.create(InputStream.nullInputStream(), true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.0", (!file.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateFolderUnderVirtualFolder() {
        IFolder folder = this.existingVirtualFolderInExistingProject.getFolder(ResourceTestUtil.createUniqueString());
        Assert.assertThrows(CoreException.class, () -> folder.create(true, true, ResourceTestUtil.createTestMonitor()));
        Assert.assertTrue((String)"2.0", (!folder.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateVirtualFolderUnderVirtualFolder() throws CoreException {
        IFolder virtualFolder = this.existingVirtualFolderInExistingProject.getFolder(ResourceTestUtil.createUniqueString());
        virtualFolder.create(8192, true, null);
        Assert.assertTrue((String)"2.0", (boolean)virtualFolder.exists());
        Assert.assertTrue((String)"3.0", (boolean)virtualFolder.isVirtual());
        virtualFolder.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCreateLinkedFolderUnderVirtualFolder() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFolder linkedFolder = this.existingVirtualFolderInExistingProject.getFolder(ResourceTestUtil.createUniqueString());
        linkedFolder.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)linkedFolder.exists());
        Assert.assertEquals((String)"3.0", (Object)location, (Object)linkedFolder.getLocation());
        Assert.assertTrue((String)"4.0", (!location.toFile().exists() ? 1 : 0) != 0);
        Assertions.assertThat((Object[])linkedFolder.members()).isEmpty();
        linkedFolder.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCreateLinkedFileUnderVirtualFolder() throws CoreException {
        IPath location = FileSystemHelper.getRandomLocation();
        IFile file = this.existingVirtualFolderInExistingProject.getFile(ResourceTestUtil.createUniqueString());
        file.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)file.exists());
        Assert.assertEquals((String)"3.0", (Object)location, (Object)file.getLocation());
        Assert.assertTrue((String)"4.0", (!location.toFile().exists() ? 1 : 0) != 0);
        file.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testCopyProjectWithVirtualFolder() throws Exception {
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        IFile linkedFile = this.existingVirtualFolderInExistingProject.getFile(ResourceTestUtil.createUniqueString());
        IFolder linkedFolder = this.existingVirtualFolderInExistingProject.getFolder(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInFileSystem(fileLocation);
        folderLocation.toFile().mkdir();
        linkedFolder.createLink(folderLocation, 0, ResourceTestUtil.createTestMonitor());
        linkedFile.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("CopyTargetProject");
        this.existingProject.copy(destinationProject.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        IFile newFile = destinationProject.getFile(linkedFile.getProjectRelativePath());
        Assert.assertTrue((String)"3.0", (boolean)newFile.isLinked());
        Assert.assertEquals((String)"3.1", (Object)linkedFile.getLocation(), (Object)newFile.getLocation());
        Assert.assertTrue((String)"3.2", (boolean)newFile.getParent().isVirtual());
        IFolder newFolder = destinationProject.getFolder(linkedFolder.getProjectRelativePath());
        Assert.assertTrue((String)"4.0", (boolean)newFolder.isLinked());
        Assert.assertEquals((String)"4.1", (Object)linkedFolder.getLocation(), (Object)newFolder.getLocation());
        Assert.assertTrue((String)"4.2", (boolean)newFolder.getParent().isVirtual());
        destinationProject.delete(0, ResourceTestUtil.createTestMonitor());
        this.existingProject.copy(destinationProject.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.1", (boolean)newFile.isLinked());
        Assert.assertEquals((String)"5.2", (Object)linkedFile.getLocation(), (Object)newFile.getLocation());
        Assert.assertTrue((String)"5.3", (boolean)newFile.getParent().isVirtual());
        Assert.assertTrue((String)"5.4", (boolean)newFolder.isLinked());
        Assert.assertEquals((String)"5.5", (Object)linkedFolder.getLocation(), (Object)newFolder.getLocation());
        Assert.assertTrue((String)"5.6", (boolean)newFolder.getParent().isVirtual());
        destinationProject.delete(0, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testMoveProjectWithVirtualFolder() throws Exception {
        IPath fileLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(fileLocation);
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        IFile file = this.existingVirtualFolderInExistingProject.getFile(ResourceTestUtil.createUniqueString());
        IFolder folder = this.existingVirtualFolderInExistingProject.getFolder(ResourceTestUtil.createUniqueString());
        IFile childFile = folder.getFile(ResourceTestUtil.createUniqueString());
        IResource[] oldResources = new IResource[]{this.existingProject, file, folder, childFile};
        ResourceTestUtil.assertDoesNotExistInWorkspace(new IResource[]{folder, file, childFile});
        ResourceTestUtil.createInFileSystem(fileLocation);
        folderLocation.toFile().mkdir();
        folder.createLink(folderLocation, 0, ResourceTestUtil.createTestMonitor());
        file.createLink(fileLocation, 0, ResourceTestUtil.createTestMonitor());
        childFile.create(ResourceTestUtil.createRandomContentsStream(), true, ResourceTestUtil.createTestMonitor());
        IProject destinationProject = ResourcesPlugin.getWorkspace().getRoot().getProject("MoveTargetProject");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)destinationProject);
        this.existingProject.move(destinationProject.getFullPath(), 32, ResourceTestUtil.createTestMonitor());
        IFile newFile = destinationProject.getFile(file.getProjectRelativePath());
        IFolder newFolder = destinationProject.getFolder(folder.getProjectRelativePath());
        IFile newChildFile = newFolder.getFile(childFile.getName());
        IResource[] newResources = new IResource[]{destinationProject, newFile, newFolder, newChildFile};
        ResourceTestUtil.assertExistsInWorkspace(newResources);
        ResourceTestUtil.assertDoesNotExistInWorkspace(oldResources);
        Assert.assertTrue((String)"7.0", (boolean)this.existingProject.isSynchronized(2));
        Assert.assertTrue((String)"8.0", (boolean)destinationProject.isSynchronized(2));
        Assert.assertTrue((String)"9.0", (boolean)newFile.getParent().isVirtual());
        Assert.assertTrue((String)"10.0", (boolean)newFile.isLinked());
        Assert.assertTrue((String)"11.0", (boolean)newFolder.isLinked());
        Assert.assertTrue((String)"12.0", (boolean)newFolder.getParent().isVirtual());
    }

    @Test
    public void testDeleteProjectWithVirtualFolder() throws CoreException {
        IFolder virtualFolder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        virtualFolder.create(8192, true, null);
        this.existingProject.delete(8, ResourceTestUtil.createTestMonitor());
        this.existingProject.create(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!virtualFolder.exists() ? 1 : 0) != 0);
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"4.0", (boolean)virtualFolder.exists());
        Assert.assertTrue((String)"5.0", (boolean)virtualFolder.isVirtual());
    }

    @Test
    public void testDeleteProjectWithVirtualFolderAndLink() throws CoreException {
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(folderLocation);
        IFolder virtualFolder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        IFolder linkedFolder = virtualFolder.getFolder("a_link");
        folderLocation.toFile().mkdir();
        virtualFolder.create(8192, true, null);
        linkedFolder.createLink(folderLocation, 0, ResourceTestUtil.createTestMonitor());
        this.existingProject.delete(8, ResourceTestUtil.createTestMonitor());
        this.existingProject.create(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (!virtualFolder.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.0", (!linkedFolder.exists() ? 1 : 0) != 0);
        this.existingProject.open(ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"5.0", (boolean)virtualFolder.exists());
        Assert.assertTrue((String)"6.0", (boolean)virtualFolder.isVirtual());
        Assert.assertTrue((String)"7.0", (boolean)linkedFolder.exists());
        Assert.assertTrue((String)"8.0", (boolean)linkedFolder.isLinked());
        Assert.assertEquals((String)"9.0", (Object)folderLocation, (Object)linkedFolder.getLocation());
    }

    @Test
    public void testLinkedFolderInVirtualFolder_FileStoreURI() throws CoreException {
        IPath folderLocation = FileSystemHelper.getRandomLocation();
        IFolder folder = this.existingVirtualFolderInExistingProject.getFolder(ResourceTestUtil.createUniqueString());
        folder.createLink(folderLocation, 16, ResourceTestUtil.createTestMonitor());
        Assert.assertTrue((String)"2.0", (boolean)folder.exists());
        Assert.assertEquals((String)"3.0", (Object)folderLocation, (Object)folder.getLocation());
        Assert.assertTrue((String)"4.0", (!folderLocation.toFile().exists() ? 1 : 0) != 0);
        IFileStore fs = EFS.getStore((URI)this.existingVirtualFolderInExistingProject.getLocationURI());
        fs = fs.getChild(folder.getName());
        Assert.assertNotNull((String)"5.0", (Object)fs);
        Assert.assertNotNull((String)"6.0", (Object)fs.toURI());
    }

    @Test
    public void testIsVirtual() throws CoreException {
        IFolder virtualFolder = this.existingProject.getFolder(ResourceTestUtil.createUniqueString());
        virtualFolder.create(8192, true, null);
        Assert.assertTrue((String)"2.0", (boolean)virtualFolder.isVirtual());
    }

    @Test
    public void testVirtualFolderInLinkedFolder() throws CoreException {
        IFolder topFolder = this.existingProject.getFolder("topFolder");
        IFolder linkedFolder = topFolder.getFolder("linkedFolder");
        IFolder subFolder = linkedFolder.getFolder("subFolder");
        IFolder virtualFolder = subFolder.getFolder("virtualFolder");
        IPath linkedFolderLocation = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(linkedFolderLocation);
        IPath subFolderLocation = linkedFolderLocation.append(subFolder.getName());
        this.workspaceRule.deleteOnTearDown(subFolderLocation);
        linkedFolderLocation.toFile().mkdir();
        subFolderLocation.toFile().mkdir();
        ResourceTestUtil.createInWorkspace((IResource)topFolder);
        linkedFolder.createLink(linkedFolderLocation, 0, ResourceTestUtil.createTestMonitor());
        virtualFolder.create(8192, true, ResourceTestUtil.createTestMonitor());
        Assert.assertEquals((String)"2.0", (Object)linkedFolderLocation, (Object)linkedFolder.getLocation());
        Assert.assertEquals((String)"3.0", (Object)linkedFolderLocation.append(subFolder.getName()), (Object)subFolder.getLocation());
        Assert.assertTrue((String)"4.0", (boolean)virtualFolder.isVirtual());
        Assert.assertTrue((String)"5.0", (virtualFolder.getLocation() == null ? 1 : 0) != 0);
        Assert.assertEquals((String)"6.0", (Object)URIUtil.toURI((IPath)linkedFolderLocation), (Object)linkedFolder.getLocationURI());
        Assert.assertEquals((String)"7.0", (Object)URIUtil.toURI((IPath)subFolderLocation), (Object)subFolder.getLocationURI());
    }

    @Test
    public void testGetVirtualFolderAttributes() {
        long timeStamp = this.existingVirtualFolderInExistingProject.getLocalTimeStamp();
        Assert.assertEquals((String)"1.0", (long)timeStamp, (long)-1L);
        ResourceAttributes attributes = this.existingVirtualFolderInExistingProject.getResourceAttributes();
        Assert.assertEquals((String)"1.1", (Object)attributes, null);
    }
}

