/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class WorkspaceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    protected IProject getTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("testProject");
    }

    protected IProject getTestProject2() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("testProject2");
    }

    public void setGetPersistentProperty(IResource target) throws Throwable {
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        target.setPersistentProperty(name, value);
        Assert.assertTrue((String)"get not equal set", (boolean)target.getPersistentProperty(name).equals(value));
        name = new QualifiedName("itp-test", "testNonProperty");
        Assert.assertNull((String)"non-existant persistent property not missing", (Object)target.getPersistentProperty(name));
    }

    @Test
    public void testFileDeletion() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFileForDelete");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(null, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
        monitor.prepare();
        target.delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFileEmptyDeletion() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFileForDelete2");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(ResourceTestUtil.createInputStream(""), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
        monitor.prepare();
        target.delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFileInFolderCreation() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFolder/testFile2");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
    }

    @Test
    public void testFileMove() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/targetFile");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        IFile destination = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"/testProject/movedFile"));
        monitor.prepare();
        target.move(destination.getFullPath(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)destination.exists());
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testFileOverFolder() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFolder");
        IFolder existing = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        Assert.assertTrue((boolean)existing.exists());
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        Assert.assertThrows(CoreException.class, () -> target.create(null, true, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)existing.exists());
    }

    @Test
    public void testFolderDeletion() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = ResourceTestUtil.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(before);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        project.getFolder("c").delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace(before);
    }

    @Test
    public void testFolderMove() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = ResourceTestUtil.buildResources((IContainer)project, new String[]{"b/", "b/b/", "b/x", "b/b/y", "b/b/z"});
        IResource[] after = ResourceTestUtil.buildResources((IContainer)project, new String[]{"a/", "a/b/", "a/x", "a/b/y", "a/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        String content = ResourceTestUtil.createRandomString();
        IFile file = project.getFile(IPath.fromOSString((String)"b/b/z"));
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        file.setContents(ResourceTestUtil.createInputStream(content), true, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        ResourceTestUtil.assertExistsInWorkspace(before);
        monitor.prepare();
        project.getFolder("b").move(project.getFullPath().append("a"), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(after);
        file = project.getFile(IPath.fromOSString((String)"a/b/z"));
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream fileContents = file.getContents(false);){
            Assertions.assertThat((InputStream)fileContents).hasContent(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFolderOverFile() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFile");
        IFile existing = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        Assert.assertTrue((boolean)existing.exists());
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        monitor.prepare();
        Assert.assertThrows(CoreException.class, () -> target.create(true, true, (IProgressMonitor)monitor));
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)existing.exists());
    }

    @Test
    public void testLeafFolderMove() throws Throwable {
        IProject project = this.getTestProject();
        IFolder source = project.getFolder("testFolder");
        IFolder dest = project.getFolder("movedFolder");
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        source.move(dest.getFullPath(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        ResourceTestUtil.assertExistsInWorkspace((IResource)dest);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)source);
    }

    @Test
    public void testMultiCreation() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("bar");
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, new String[]{"a/", "a/b"});
        IWorkspaceRunnable body = monitor -> {
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray2[n2];
                switch (resource.getType()) {
                    case 1: {
                        ((IFile)resource).create(null, false, monitor);
                        break;
                    }
                    case 2: {
                        ((IFolder)resource).create(false, true, monitor);
                        break;
                    }
                    case 4: {
                        ((IProject)resource).create(monitor);
                    }
                }
                ++n2;
            }
        };
        FussyProgressMonitor monitor2 = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().run(body, (IProgressMonitor)monitor2);
        monitor2.assertUsedUp();
        ResourceTestUtil.assertExistsInWorkspace((IResource)project);
        ResourceTestUtil.assertExistsInWorkspace(resources);
    }

    @Test
    public void testMultiDeletion() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = ResourceTestUtil.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        ResourceTestUtil.createInWorkspace(before);
        ResourceTestUtil.assertExistsInWorkspace(before);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        ResourcesPlugin.getWorkspace().delete(before, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        ResourceTestUtil.assertDoesNotExistInWorkspace(before);
    }

    @Test
    public void testProjectCloseOpen() throws Throwable {
        IProject target = this.getTestProject();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.close((IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
        Assert.assertTrue((!target.isOpen() ? 1 : 0) != 0);
        Assert.assertTrue((!target.getFolder("testFolder").exists() ? 1 : 0) != 0);
        monitor.prepare();
        target.open((IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.isOpen());
        Assert.assertTrue((boolean)target.getFolder("testFolder").exists());
    }

    @Test
    public void testProjectCreateOpenCloseDelete() throws Throwable {
        IProject target = this.getTestProject2();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(null, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
        monitor.prepare();
        target.open((IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.isOpen());
        monitor.prepare();
        target.close((IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((!target.isOpen() ? 1 : 0) != 0);
        monitor.prepare();
        target.delete(true, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    @Before
    public void setUp() throws Exception {
        IProject target = this.getTestProject();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(null, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
        monitor.prepare();
        target.open((IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.isOpen());
        IPath path = IPath.fromOSString((String)"/testProject/testFolder");
        IFolder folderTarget = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        monitor = new FussyProgressMonitor();
        folderTarget.create(true, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)folderTarget.exists());
        IPath filePath = IPath.fromOSString((String)"/testProject/testFile");
        IFile fileTarget = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        monitor = new FussyProgressMonitor();
        fileTarget.create(null, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)fileTarget.exists());
        String testString = ResourceTestUtil.createRandomString();
        monitor = new FussyProgressMonitor();
        fileTarget.setContents(testString.getBytes(), true, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Throwable throwable = null;
        Object var9_10 = null;
        try (InputStream content = fileTarget.getContents(false);){
            Assertions.assertThat((InputStream)content).hasContent(testString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testProjectDeletion() throws Throwable {
        IProject target = this.getTestProject();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"Project Deletion failed", (!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingLocationDeletion_bug433061() throws Throwable {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        IProject project = this.getTestProject();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        IPath workingLocation = project.getWorkingLocation("org.eclipse.core.tests.resources");
        IPath linkTarget = FileSystemHelper.getRandomLocation();
        this.workspaceRule.deleteOnTearDown(linkTarget);
        linkTarget.toFile().mkdirs();
        File file = linkTarget.append("aFile").toFile();
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.exists());
        FileSystemHelper.createSymLink((File)workingLocation.toFile(), (String)"link", (String)linkTarget.toOSString(), (boolean)true);
        monitor.prepare();
        project.delete(true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((String)"Project deletion failed", (!project.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Working location was not deleted", (!workingLocation.toFile().exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"File inside a symlinked directory got deleted", (boolean)file.exists());
    }

    @Test
    public void testProjectReferences() throws Throwable {
        IProject target = this.getTestProject2();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(null, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)target.exists());
        IProject project = this.getTestProject();
        IProjectDescription description = project.getDescription();
        description.setReferencedProjects(new IProject[]{target});
        monitor.prepare();
        project.setDescription(description, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assertions.assertThat((Object[])target.getReferencingProjects()).hasSize(1);
        monitor.prepare();
        target.delete(true, true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testDanglingReferences() throws Throwable {
        IProject p1 = null;
        IProject p2 = null;
        p2 = ResourcesPlugin.getWorkspace().getRoot().getProject("p2");
        p2.create((IProgressMonitor)new NullProgressMonitor());
        p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p1");
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription("p1");
        description.setReferencedProjects(new IProject[]{p2});
        p1.create(description, (IProgressMonitor)new NullProgressMonitor());
        p1.open((IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)ResourcesPlugin.getWorkspace().getDanglingReferences().containsKey(p1));
        p2.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertThat((Object[])((IProject[])ResourcesPlugin.getWorkspace().getDanglingReferences().get(p1))).containsExactly((Object[])new IProject[]{p2});
    }

    @Test
    public void testSetContents() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFile");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String testString = ResourceTestUtil.createRandomString();
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.setContents(ResourceTestUtil.createInputStream(testString), true, false, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream content = target.getContents(false);){
            Assertions.assertThat((InputStream)content).hasContent(testString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSetGetFilePersistentProperty() throws Throwable {
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"/testProject/testFile"));
        this.setGetPersistentProperty((IResource)target);
    }

    @Test
    public void testSetGetFolderPersistentProperty() throws Throwable {
        IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder(IPath.fromOSString((String)"/testProject/testFolder"));
        this.setGetPersistentProperty((IResource)target);
    }

    @Test
    public void testSetGetProjectPersistentProperty() throws Throwable {
        IProject target = ResourcesPlugin.getWorkspace().getRoot().getProject("/testProject");
        this.setGetPersistentProperty((IResource)target);
    }

    @Test
    public void testSetProperty() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/testFile");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        target.setPersistentProperty(name, value);
        Assert.assertTrue((String)"get not equal set", (boolean)target.getPersistentProperty(name).equals(value));
    }

    @Test
    public void testSimpleMove() throws Throwable {
        IPath path = IPath.fromOSString((String)"/testProject/simpleFile");
        IFile target = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        FussyProgressMonitor monitor = new FussyProgressMonitor();
        target.create(ResourceTestUtil.createRandomContentsStream(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        IFile destination = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)"/testProject/newSimpleFile"));
        monitor.prepare();
        target.move(destination.getFullPath(), true, (IProgressMonitor)monitor);
        monitor.assertUsedUp();
        Assert.assertTrue((boolean)destination.exists());
        Assert.assertTrue((!target.exists() ? 1 : 0) != 0);
    }
}

