/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.FreezeMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestUtil;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WorkspaceTestRule
extends ExternalResource {
    private String testName;
    private final Set<IFileStore> storesToDelete = new HashSet<IFileStore>();

    public Statement apply(Statement base, Description description) {
        this.testName = description.getDisplayName();
        return super.apply(base, description);
    }

    protected void setTestName(String name) {
        this.testName = name;
    }

    protected void before() throws Exception {
        ResourceTestUtil.waitForRefresh();
        TestUtil.log(1, this.testName, "setUp", new Throwable[0]);
        Assert.assertNotNull((String)"Workspace was not setup", (Object)ResourcesPlugin.getWorkspace());
        FreezeMonitor.expectCompletionInAMinute();
        ResourceTestUtil.waitForRefresh();
    }

    protected void after() {
        TestUtil.log(1, this.testName, "tearDown", new Throwable[0]);
        try {
            this.restoreCleanWorkspace();
        }
        finally {
            FreezeMonitor.done();
            this.assertWorkspaceFolderEmpty();
        }
    }

    private void restoreCleanWorkspace() {
        ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
        try {
            this.restoreWorkspaceDescription();
        }
        catch (CoreException e) {
            exceptions.add(e);
        }
        ResourceTestUtil.waitForBuild();
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                ResourcesPlugin.getWorkspace().getRoot().delete(true, true, ResourceTestUtil.createTestMonitor());
                for (IFileStore element : this.storesToDelete) {
                    this.clear(element);
                }
                this.storesToDelete.clear();
            }, null);
        }
        catch (CoreException e) {
            exceptions.add(e);
        }
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException e) {
            exceptions.add(e);
        }
        ResourceTestUtil.waitForBuild();
        if (!exceptions.isEmpty()) {
            IllegalStateException composedException = new IllegalStateException("Failures when cleaning up workspace");
            exceptions.forEach(exception -> composedException.addSuppressed((Throwable)exception));
            throw composedException;
        }
    }

    private void restoreWorkspaceDescription() throws CoreException {
        ResourcesPlugin.getWorkspace().setDescription((IWorkspaceDescription)Workspace.defaultWorkspaceDescription());
    }

    private void assertWorkspaceFolderEmpty() {
        String metadataDirectoryName = ".metadata";
        File workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        Object[] remainingFilesInWorkspace = workspaceLocation.listFiles(file -> !file.getName().equals(".metadata"));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])remainingFilesInWorkspace).as("contents in the workspace folder", new Object[0])).isEmpty();
    }

    public IFileStore getTempStore() {
        IFileStore store = EFS.getLocalFileSystem().getStore(FileSystemHelper.getRandomLocation((IPath)FileSystemHelper.getTempDir()));
        this.deleteOnTearDown(store);
        return store;
    }

    public void deleteOnTearDown(IPath path) {
        this.storesToDelete.add(EFS.getLocalFileSystem().getStore(path));
    }

    public void deleteOnTearDown(IFileStore store) {
        this.storesToDelete.add(store);
    }

    private void clear(IFileStore store) throws CoreException {
        store.delete(0, null);
    }
}

