/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.IContentTypeInfo;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContentDescriptionTest {
    private static final String CT_VOID = "org.eclipse.core.tests.resources.void";
    private static final QualifiedName ZOO_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "zoo");
    private static final QualifiedName BAR_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "bar");
    private static final QualifiedName FOO_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "foo");
    private static final QualifiedName FRED_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "fred");

    private ContentType getContentType() {
        return ((ContentTypeHandler)Platform.getContentTypeManager().getContentType(CT_VOID)).getTarget();
    }

    @Test
    public void testAllProperties() {
        ContentDescription description = new ContentDescription(IContentDescription.ALL, (IContentTypeInfo)this.getContentType());
        Assertions.assertTrue((boolean)description.isRequested(FOO_PROPERTY));
        Assertions.assertNull((Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1b");
        Assertions.assertEquals((Object)"value1b", (Object)description.getProperty(FOO_PROPERTY));
        Assertions.assertTrue((boolean)description.isRequested(BAR_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        Assertions.assertEquals((Object)"value2", (Object)description.getProperty(BAR_PROPERTY));
        description.setProperty(ZOO_PROPERTY, (Object)"value3");
        Assertions.assertEquals((Object)"value3", (Object)description.getProperty(ZOO_PROPERTY));
        description.markImmutable();
        Assertions.assertThrows(IllegalStateException.class, () -> description.setProperty(FOO_PROPERTY, (Object)"value1c"));
    }

    @Test
    public void testOneProperty() {
        ContentDescription description = new ContentDescription(new QualifiedName[]{FOO_PROPERTY}, (IContentTypeInfo)this.getContentType());
        Assertions.assertTrue((boolean)description.isRequested(FOO_PROPERTY));
        Assertions.assertNull((Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1b");
        Assertions.assertEquals((Object)"value1b", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        Assertions.assertFalse((boolean)description.isRequested(BAR_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        Assertions.assertNull((Object)description.getProperty(BAR_PROPERTY));
        description.markImmutable();
        Assertions.assertThrows(IllegalStateException.class, () -> description.setProperty(FOO_PROPERTY, (Object)"value1c"));
    }

    @Test
    public void testZeroProperties() {
        ContentDescription description = new ContentDescription(new QualifiedName[0], (IContentTypeInfo)this.getContentType());
        Assertions.assertFalse((boolean)description.isRequested(FOO_PROPERTY));
        Assertions.assertNull((Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        Assertions.assertNull((Object)description.getProperty(FOO_PROPERTY));
        description.markImmutable();
        Assertions.assertThrows(IllegalStateException.class, () -> description.setProperty(FOO_PROPERTY, (Object)"value1b"));
    }

    @Test
    public void testMultipleProperties() {
        ContentDescription description = new ContentDescription(new QualifiedName[]{FOO_PROPERTY, BAR_PROPERTY, ZOO_PROPERTY}, (IContentTypeInfo)this.getContentType());
        Assertions.assertTrue((boolean)description.isRequested(FOO_PROPERTY));
        Assertions.assertNull((Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1b");
        Assertions.assertEquals((Object)"value1b", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        Assertions.assertTrue((boolean)description.isRequested(BAR_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        Assertions.assertEquals((Object)"value2", (Object)description.getProperty(BAR_PROPERTY));
        Assertions.assertTrue((boolean)description.isRequested(ZOO_PROPERTY));
        description.setProperty(ZOO_PROPERTY, (Object)"value3");
        Assertions.assertEquals((Object)"value3", (Object)description.getProperty(ZOO_PROPERTY));
        Assertions.assertFalse((boolean)description.isRequested(FRED_PROPERTY));
        description.setProperty(FRED_PROPERTY, (Object)"value3");
        Assertions.assertNull((Object)description.getProperty(FRED_PROPERTY));
        description.markImmutable();
        Assertions.assertThrows(IllegalStateException.class, () -> description.setProperty(FOO_PROPERTY, (Object)"value1c"));
    }
}

