/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.core.tests.harness.TestRegistryChangeListener;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.content.LocalSelectionPolicy;
import org.eclipse.core.tests.resources.content.MyContentDescriber;
import org.eclipse.core.tests.resources.content.SubsetSelectionPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class IContentTypeManagerTest {
    private static final String TEST_FILES_ROOT = "Plugin_Testing/";
    private static final String FAMILY_CHARSET_DELTA = "org.eclipse.core.resources.charsetJobFamily";
    private static final String MINIMAL_XML = "<?xml version=\"1.0\"?><org.eclipse.core.resources.tests.root/>";
    private static final String SAMPLE_BIN1_OFFSET = "12345";
    private static final byte[] SAMPLE_BIN1_SIGNATURE = new byte[]{16, -85, -51, -1};
    private static final String SAMPLE_BIN2_OFFSET = "";
    private static final byte[] SAMPLE_BIN2_SIGNATURE = new byte[]{16, -85, -51, -17};
    private static final String XML_DTD_EXTERNAL_ENTITY = "<?xml version=\"1.0\"?><!DOCTYPE project  SYSTEM \"org.eclipse.core.resources.tests.some.dtd\"  [<!ENTITY someentity SYSTEM \"someentity.xml\">]><org.eclipse.core.resources.tests.root/>";
    private static final String XML_DTD_US_ASCII = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><!DOCTYPE sometype SYSTEM \"org.eclipse.core.resources.tests.some.dtd\"><org.eclipse.core.resources.tests.root/>";
    private static final String XML_ISO_8859_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_ISO_8859_1_SINGLE_QUOTES = "<?xml version='1.0' encoding='ISO-8859-1'?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_ROOT_ELEMENT_EXTERNAL_ENTITY = "<?xml version=\"1.0\"?><!DOCTYPE project   [<!ENTITY someentity SYSTEM \"someentity.xml\">]><org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_ROOT_ELEMENT_EXTERNAL_ENTITY2 = "<?xml version=\"1.0\"?><!DOCTYPE org.eclipse.core.resources.tests.root-element PUBLIC \"org.eclipse.core.resources.tests.root-elementId\" \"org.eclipse.core.resources.tests.root-element.dtd\" ><org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_ROOT_ELEMENT_ISO_8859_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_ROOT_ELEMENT_NO_DECL = "<org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_US_ASCII_INVALID = "<?xml version='1.0' encoding='us-ascii'?><!-- Non-ASCII chars: \ufffd\ufffd\ufffd\ufffd\ufffd --><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_16 = "<?xml version=\"1.0\" encoding=\"UTF-16\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_16BE = "<?xml version=\"1.0\" encoding=\"UTF-16BE\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_16LE = "<?xml version=\"1.0\" encoding=\"UTF-16LE\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><org.eclipse.core.resources.tests.root/>";
    public static final String XML_ROOT_ELEMENT_NS_MATCH1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><prefix:rootElement1 xmlns:prefix='urn:eclipse.core.runtime.ns1'/>";
    private static final String XML_ROOT_ELEMENT_NS_MATCH2 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE rootElement2 SYSTEM \"org.eclipse.core.resources.tests.nothing\"><rootElement2 xmlns='urn:eclipse.core.runtime.ns2'/>";
    private static final String XML_ROOT_ELEMENT_NS_WRONG_ELEM = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><rootElement3 xmlns='urn:eclipse.core.runtime.ns2'/>";
    private static final String XML_ROOT_ELEMENT_NS_WRONG_NS = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><prefix:rootElement1 xmlns='http://example.com/'/>";
    private static final String XML_ROOT_ELEMENT_NS_MIXUP = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><rootElement2 xmlns='urn:eclipse.core.runtime.ns1'/>";
    private static final String XML_ROOT_ELEMENT_NS_WILDCARD = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><weCouldPutAnythingHere xmlns='urn:eclipse.core.runtime.nsWild'/>";
    private static final String XML_ROOT_ELEMENT_NS_WILDCARD2 = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><!DOCTYPE Joker SYSTEM \"org.eclipse.core.resources.tests.some.dtd3\"><Joker/>";
    private static final String XML_ROOT_ELEMENT_EMPTY_NS = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><!DOCTYPE Joker SYSTEM \"org.eclipse.core.resources.tests.some.dtd3\"><rootElement>";

    private String changeCase(String original) {
        StringBuilder result = new StringBuilder(original);
        int i = result.length() - 1;
        while (i >= 0) {
            char originalChar = original.charAt(i);
            result.setCharAt(i, i % 2 == 0 ? Character.toLowerCase(originalChar) : Character.toUpperCase(originalChar));
            --i;
        }
        return result.toString();
    }

    private IContentDescription getDescriptionFor(IContentTypeMatcher finder, String contents, Charset encoding, String fileName, QualifiedName[] options, boolean text) throws IOException {
        return text ? finder.getDescriptionFor(this.getReader(contents), fileName, options) : finder.getDescriptionFor(this.getInputStream(contents, encoding), fileName, options);
    }

    public InputStream getInputStream(byte[][] contents) {
        int size = 0;
        byte[][] byArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] content = byArray[n2];
            size += content.length;
            ++n2;
        }
        byte[] full = new byte[size];
        int fullIndex = 0;
        byte[][] byArray2 = contents;
        int n3 = contents.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] content;
            byte[] byArray3 = content = byArray2[n4];
            int n5 = content.length;
            int n6 = 0;
            while (n6 < n5) {
                byte element = byArray3[n6];
                full[fullIndex++] = element;
                ++n6;
            }
            ++n4;
        }
        return new ByteArrayInputStream(full);
    }

    public InputStream getInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public InputStream getInputStream(String contents, Charset encoding) {
        return new ByteArrayInputStream(encoding == null ? contents.getBytes() : contents.getBytes(encoding));
    }

    public Reader getReader(String contents) {
        return new CharArrayReader(contents.toCharArray());
    }

    private boolean isText(IContentTypeManager manager, IContentType candidate) {
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        return candidate.isKindOf(text);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Job.getJobManager().wakeUp((Object)FAMILY_CHARSET_DELTA);
        Job.getJobManager().join((Object)FAMILY_CHARSET_DELTA, (IProgressMonitor)new FussyProgressMonitor());
    }

    @Test
    public void testAlias() throws Exception {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType alias = contentTypeManager.getContentType("org.eclipse.core.tests.resources.alias");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)alias);
        IContentType derived = contentTypeManager.getContentType("org.eclipse.core.tests.resources.derived-from-alias");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)derived);
        IContentType target = contentTypeManager.getContentType("org.eclipse.bundle02.missing-target");
        org.junit.jupiter.api.Assertions.assertNull((Object)target);
        Object[] selected = contentTypeManager.findContentTypesFor("foo.missing-target");
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{alias, derived});
        selected = contentTypeManager.findContentTypesFor(ResourceTestUtil.createRandomContentsStream(), "foo.missing-target");
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{alias, derived});
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles(() -> {
            IContentType alias1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.alias");
            org.junit.jupiter.api.Assertions.assertNull((Object)alias1);
            IContentType derived1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.derived-from-alias");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)derived1);
            IContentType target1 = contentTypeManager.getContentType("org.eclipse.bundle02.missing-target");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)target1);
            Object[] selected1 = contentTypeManager.findContentTypesFor("foo.missing-target");
            Assertions.assertThat((Object[])selected1).containsExactly((Object[])new IContentType[]{target1, derived1});
            Object[] selected2 = contentTypeManager.findContentTypesFor(ResourceTestUtil.createRandomContentsStream(), "foo.missing-target");
            Assertions.assertThat((Object[])selected2).containsExactly((Object[])new IContentType[]{target1, derived1});
            return null;
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle02"}, (TestRegistryChangeListener)listener);
    }

    @Test
    public void testAssociationInheritance() throws CoreException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = manager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        IContentType assoc1 = manager.getContentType("org.eclipse.core.tests.resources.assoc1");
        IContentType assoc2 = manager.getContentType("org.eclipse.core.tests.resources.assoc2");
        text.addFileSpec("txt_useradded", 8);
        assoc1.addFileSpec("txt_assoc1useradded", 8);
        assoc2.addFileSpec("txt_assoc2useradded", 8);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc1.isAssociatedWith(this.changeCase("text.txt")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_useradded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_assoc1pluginadded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_assoc1useradded")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)assoc2.isAssociatedWith(this.changeCase("text.txt")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_useradded")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_assoc2pluginadded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_assoc2builtin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_assoc2useradded")));
        Object[] selected = finder.findContentTypesFor(this.changeCase("text.txt"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{text, assoc1});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_useradded"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{text, assoc1});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_pluginadded"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{text, assoc1});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc1pluginadded"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{assoc1});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc1useradded"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{assoc1});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc2pluginadded"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{assoc2});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc2useradded"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{assoc2});
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc2builtin"));
        Assertions.assertThat((Object[])selected).containsExactly((Object[])new IContentType[]{assoc2});
    }

    @Test
    public void testAssociations() throws CoreException {
        IContentType text = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        text.addFileSpec("txt_useradded", 8);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt_useradded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        Object[] providerDefinedExtensions = text.getFileSpecs(10);
        Assertions.assertThat((Object[])providerDefinedExtensions).contains((Object[])new String[]{"txt"});
        Assertions.assertThat((Object[])providerDefinedExtensions).doesNotContain((Object[])new String[]{"txt_useradded"});
        Assertions.assertThat((Object[])providerDefinedExtensions).contains((Object[])new String[]{"txt_pluginadded"});
        Object[] textUserDefinedExtensions = text.getFileSpecs(9);
        Assertions.assertThat((Object[])textUserDefinedExtensions).doesNotContain((Object[])new String[]{"txt"});
        Assertions.assertThat((Object[])textUserDefinedExtensions).contains((Object[])new String[]{"txt_useradded"});
        Assertions.assertThat((Object[])textUserDefinedExtensions).doesNotContain((Object[])new String[]{"txt_pluginadded"});
        text.removeFileSpec("txt", 8);
        Assertions.assertThat((Object[])text.getFileSpecs(10)).contains((Object[])new String[]{"txt"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt_useradded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        text.removeFileSpec("txt_useradded", 8);
        Assertions.assertThat((Object[])text.getFileSpecs(9)).doesNotContain((Object[])new String[]{"ini"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith(this.changeCase("text.txt_useradded")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
    }

    @Test
    public void testBinaryTypes() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType sampleBinary1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        IContentType sampleBinary2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary2");
        InputStream contents = this.getInputStream(new byte[][]{SAMPLE_BIN1_OFFSET.getBytes(), SAMPLE_BIN1_SIGNATURE, " extra contents".getBytes()});
        IContentDescription description = contentTypeManager.getDescriptionFor(contents, null, IContentDescription.ALL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)sampleBinary1, (Object)description.getContentType());
        contents = this.getInputStream(new byte[][]{SAMPLE_BIN2_OFFSET.getBytes(), SAMPLE_BIN2_SIGNATURE, " extra contents".getBytes()});
        description = contentTypeManager.getDescriptionFor(contents, null, IContentDescription.ALL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)sampleBinary2, (Object)description.getContentType());
        Object[] selected = contentTypeManager.findContentTypesFor("test.samplebin2");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])selected).hasSize(1)).allSatisfy(element -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)element.getId()).isEqualTo(sampleBinary2.getId());
        });
        description = contentTypeManager.getDescriptionFor(this.getReader(ResourceTestUtil.createRandomString()), "test.samplebin2", IContentDescription.ALL);
        org.junit.jupiter.api.Assertions.assertNull((Object)description);
    }

    @Test
    public void testByteOrderMark() throws IOException {
        IContentType text = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        QualifiedName[] options = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};
        String UTF8_BOM = new String(IContentDescription.BOM_UTF_8, StandardCharsets.ISO_8859_1);
        IContentDescription description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF8_BOM + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        org.junit.jupiter.api.Assertions.assertEquals((Object)IContentDescription.BOM_UTF_8, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_LE_BOM = new String(IContentDescription.BOM_UTF_16LE, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF16_LE_BOM + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        org.junit.jupiter.api.Assertions.assertEquals((Object)IContentDescription.BOM_UTF_16LE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_BE_BOM = new String(IContentDescription.BOM_UTF_16BE, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF16_BE_BOM + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        org.junit.jupiter.api.Assertions.assertEquals((Object)IContentDescription.BOM_UTF_16BE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(MINIMAL_XML.getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_BE_BOM_1byte = new String(new byte[]{-2}, "ISO-8859-1");
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF16_BE_BOM_1byte + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF16_BE_BOM_1byte.getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_LE_BOM_1byte = new String(new byte[]{-1}, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF16_LE_BOM_1byte + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF16_LE_BOM_1byte.getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF8_BOM_1byte = new String(new byte[]{-17}, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF8_BOM_1byte + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF8_BOM_1byte.getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF8_BOM_2bytes = new String(new byte[]{-17, -69}, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((UTF8_BOM_2bytes + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF8_BOM_2bytes.getBytes(StandardCharsets.ISO_8859_1)), options);
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
    }

    @Test
    public void testContentAndNameMatching() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        byte[][] contents0 = new byte[][]{{10, 11, 14, 16}};
        byte[][] contents1 = new byte[][]{{10, 11, 12, 16}};
        byte[][] contents2 = new byte[][]{{10, 11, 13, 16}};
        byte[][] invalidContents = new byte[][]{new byte[4]};
        IContentType base = manager.getContentType("org.eclipse.core.tests.resources.binary_base");
        IContentType derived1 = manager.getContentType("org.eclipse.core.tests.resources.binary_derived1");
        IContentType derived2 = manager.getContentType("org.eclipse.core.tests.resources.binary_derived2");
        Object[] selected = manager.findContentTypesFor(this.getInputStream(contents0), "anything.mybinary");
        Assertions.assertThat((Object[])selected).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)base, (Object)selected[0]);
        selected = manager.findContentTypesFor(this.getInputStream(contents0), "foo.mybinary");
        Assertions.assertThat((Object[])selected).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)base, (Object)selected[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)derived1, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(contents1), "foo.mybinary");
        Assertions.assertThat((Object[])selected).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)derived1, (Object)selected[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)base, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(contents2), "foo.mybinary");
        Assertions.assertThat((Object[])selected).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)derived2, (Object)selected[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)base, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(invalidContents), "foo.mybinary");
        Assertions.assertThat((Object[])selected).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)derived1, (Object)selected[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)base, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(invalidContents), "anything.mybinary");
        Assertions.assertThat((Object[])selected).hasSize(3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)base, (Object)selected[0]);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testContentDescription(boolean text) throws IOException, CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType xmlType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType mytext = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext");
        IContentType mytext1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext1");
        IContentType mytext2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext2");
        IContentDescription description = this.getDescriptionFor(finder, MINIMAL_XML, StandardCharsets.UTF_8, "foo.xml", IContentDescription.ALL, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, MINIMAL_XML, StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-8", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, XML_ISO_8859_1, StandardCharsets.ISO_8859_1, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ISO-8859-1", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertNotSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, XML_ISO_8859_1_SINGLE_QUOTES, StandardCharsets.ISO_8859_1, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ISO-8859-1", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertNotSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, XML_UTF_16, StandardCharsets.UTF_16, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-16", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertTrue((text || IContentDescription.BOM_UTF_16BE == description.getProperty(IContentDescription.BYTE_ORDER_MARK) ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, XML_UTF_16BE, StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-16BE", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertNotSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, XML_UTF_16LE, StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-16LE", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertNotSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, MINIMAL_XML, StandardCharsets.UTF_8, "foo.xml", IContentDescription.ALL, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-8", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)mytext);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)mytext.getDefaultCharset());
        org.junit.jupiter.api.Assertions.assertSame((Object)xmlType.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)mytext, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertSame((Object)mytext.getDefaultDescription(), (Object)description);
        mytext.setDefaultCharset("FOO");
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)mytext, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FOO", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertSame((Object)mytext.getDefaultDescription(), (Object)description);
        mytext.setDefaultCharset(null);
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)mytext, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertSame((Object)mytext.getDefaultDescription(), (Object)description);
        description = this.getDescriptionFor(finder, "<?xml version='1.0' encoding='UTF-8'?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tns=\"http://www.example.org/\" xmlns:ns0=\"http://another.example.org/\"><soapenv:Header /><soapenv:Body><ns0:x /></soapenv:Body></soapenv:Envelope>", StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-8", (Object)description.getProperty(IContentDescription.CHARSET));
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlType.getDefaultDescription().getCharset(), (Object)description.getCharset());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)mytext1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)mytext1.getDefaultCharset());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)mytext2);
        org.junit.jupiter.api.Assertions.assertNull((Object)mytext2.getDefaultCharset());
    }

    @Test
    public void testContentDetection() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType inappropriate = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        IContentType appropriate = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType appropriateSpecific1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension");
        IContentType appropriateSpecific1LowPriority = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension-low-priority");
        IContentType appropriateSpecific2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-specific-name");
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate}), null);
        org.junit.jupiter.api.Assertions.assertNull((Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate}), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)appropriate, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate, appropriateSpecific1}), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)appropriateSpecific1, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate, appropriateSpecific2}), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)appropriateSpecific2, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate, appropriateSpecific1, appropriateSpecific2}), null);
        Object[] selected = finder.findContentTypesFor(this.getInputStream(MINIMAL_XML), null);
        Assertions.assertThat((Object[])selected).satisfiesAnyOf(new ThrowingConsumer[]{elements -> {
            AbstractObjectArrayAssert abstractObjectArrayAssert = Assertions.assertThat((Object[])elements).containsExactly((Object[])new IContentType[]{appropriateSpecific1, appropriateSpecific2, appropriate});
        }, elements -> {
            AbstractObjectArrayAssert abstractObjectArrayAssert = Assertions.assertThat((Object[])elements).containsExactly((Object[])new IContentType[]{appropriateSpecific2, appropriateSpecific1, appropriate});
        }});
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{appropriate, appropriateSpecific1LowPriority}), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)appropriateSpecific1LowPriority, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{appropriate, appropriateSpecific1, appropriateSpecific1LowPriority}), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)appropriateSpecific1, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
    }

    @Test
    public void testDefaultProperties() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType mytext = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext");
        IContentType mytext1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext1");
        IContentType mytext2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext2");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)mytext);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)mytext1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)mytext2);
        QualifiedName charset = IContentDescription.CHARSET;
        QualifiedName localCharset = new QualifiedName("org.eclipse.core.tests.resources", "charset");
        QualifiedName property1 = new QualifiedName("org.eclipse.core.tests.resources", "property1");
        QualifiedName property2 = new QualifiedName("org.eclipse.core.tests.resources", "property2");
        QualifiedName property3 = new QualifiedName("org.eclipse.core.tests.resources", "property3");
        QualifiedName property4 = new QualifiedName("org.eclipse.core.tests.resources", "property4");
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentDescription description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)mytext, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value1", (Object)description.getProperty(property1));
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(property2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value3", (Object)description.getProperty(property3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)description.getProperty(charset));
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt1", IContentDescription.ALL, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)mytext1, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value1", (Object)description.getProperty(property1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value2", (Object)description.getProperty(property2));
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(property3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value4", (Object)description.getProperty(property4));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)description.getProperty(charset));
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt2", IContentDescription.ALL, true);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)mytext2, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(property1));
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(property2));
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(property3));
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(property4));
        org.junit.jupiter.api.Assertions.assertNull((Object)description.getProperty(charset));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mytext2", (Object)description.getProperty(localCharset));
    }

    @Test
    public void testDoubleAssociation() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType fooBarType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.fooBar");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fooBarType);
        IContentType subFooBarType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.subFooBar");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)subFooBarType);
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        Object[] fooBarAssociated = finder.findContentTypesFor(this.changeCase("foo.bar"));
        Assertions.assertThat((Object[])fooBarAssociated).containsExactlyInAnyOrder((Object[])new IContentType[]{fooBarType, subFooBarType});
    }

    @Test
    public void testDynamicChanges() throws Exception {
        IContentType[] text = new IContentType[4];
        IContentTypeManager manager = Platform.getContentTypeManager();
        text[0] = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text[0]);
        text[1] = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text[1]);
        text[0] = ((ContentTypeHandler)text[0]).getTarget();
        text[1] = ((ContentTypeHandler)text[1]).getTarget();
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[1]);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles(() -> {
            IContentType missing = manager.getContentType("org.eclipse.bundle01.missing");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)missing);
            iContentTypeArray[2] = manager.getContentType("org.eclipse.core.runtime.text");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)text[2]);
            iContentTypeArray[2] = ((ContentTypeHandler)text[2]).getTarget();
            org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[2]);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)text[0], (Object)text[2]);
            return null;
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle01"}, (TestRegistryChangeListener)listener);
        org.junit.jupiter.api.Assertions.assertNull((Object)manager.getContentType("org.eclipse.bundle01.missing"));
        text[3] = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text[3]);
        text[3] = ((ContentTypeHandler)text[3]).getTarget();
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[3]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[2], (Object)text[3]);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)text[0], (Object)text[3]);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)text[2], (Object)text[3]);
    }

    @Test
    public void testDynamicChangesNewExtension() throws Exception {
        IContentType[] text = new IContentType[4];
        IContentTypeManager manager = Platform.getContentTypeManager();
        text[0] = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text[0]);
        text[1] = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text[1]);
        text[0] = ((ContentTypeHandler)text[0]).getTarget();
        text[1] = ((ContentTypeHandler)text[1]).getTarget();
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[1]);
        org.junit.jupiter.api.Assertions.assertSame((Object)text[0], (Object)text[1]);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.contenttype", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles(() -> {
            IContentType contentType = manager.getContentType("org.eclipse.bug485227.bug485227_contentType");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)contentType, (String)"Contributed content type not found");
            iContentTypeArray[2] = manager.getContentType("org.eclipse.core.runtime.text");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)text[2], (String)"Text content type not modified");
            iContentTypeArray[2] = ((ContentTypeHandler)text[2]).getTarget();
            org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[2]);
            org.junit.jupiter.api.Assertions.assertNotSame((Object)text[0], (Object)text[2]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)contentType, (Object)manager.findContentTypeFor("file.bug485227"), (String)"default extension not associated");
            org.junit.jupiter.api.Assertions.assertEquals((Object)contentType, (Object)manager.findContentTypeFor("file.bug485227_2"), (String)"additional extension not associated");
            return null;
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bug485227"}, (TestRegistryChangeListener)listener);
        org.junit.jupiter.api.Assertions.assertNull((Object)manager.getContentType("org.eclipse.bug485227.bug485227_contentType"), (String)"Content type not cleared after bundle uninstall");
        text[3] = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text[3]);
        text[3] = ((ContentTypeHandler)text[3]).getTarget();
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[0], (Object)text[3]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)text[2], (Object)text[3]);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)text[0], (Object)text[3]);
        org.junit.jupiter.api.Assertions.assertNotSame((Object)text[2], (Object)text[3]);
    }

    @Test
    public void testEvents() throws CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType myType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.myContent");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)myType);
        ContentTypeChangeTracer tracer = new ContentTypeChangeTracer();
        contentTypeManager.addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)tracer);
        myType.addFileSpec("another.file.name", 4);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        myType.removeFileSpec("another.file.name", 8);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        myType.addFileSpec("another.file.name", 4);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        myType.removeFileSpec("another.file.name", 4);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        myType.setDefaultCharset("FOO");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        myType.setDefaultCharset("FOO");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)tracer.isOnlyChange(myType));
        myType.setDefaultCharset("ABC");
    }

    @Test
    public void testFileSpecConflicts() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType conflict1a = manager.getContentType("org.eclipse.core.tests.resources.base_conflict1");
        IContentType conflict1b = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict1a);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict1b);
        IContentType preferredConflict1 = manager.findContentTypeFor("test.conflict1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)preferredConflict1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)conflict1a, (Object)preferredConflict1);
        IContentType conflict2base = manager.getContentType("org.eclipse.core.tests.resources.base_conflict2");
        IContentType conflict2sub = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict2");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict2base);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict2sub);
        Object[] selectedConflict2 = manager.findContentTypesFor(ResourceTestUtil.createRandomContentsStream(), "test.conflict2");
        Assertions.assertThat((Object[])selectedConflict2).containsExactly((Object[])new IContentType[]{conflict2base, conflict2sub});
        IContentType conflict2abase = manager.getContentType("org.eclipse.core.tests.resources.base_conflict2a");
        IContentType conflict2asub = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict2a");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict2abase);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict2asub);
        Object[] selectedConflict2a = manager.findContentTypesFor(this.getInputStream("conflict2a", StandardCharsets.UTF_8), "test.conflict2a");
        Assertions.assertThat((Object[])selectedConflict2a).containsExactly((Object[])new IContentType[]{conflict2asub, conflict2abase});
        selectedConflict2a = manager.findContentTypesFor("test.conflict2a");
        Assertions.assertThat((Object[])selectedConflict2a).containsExactly((Object[])new IContentType[]{conflict2abase, conflict2asub});
        IContentType conflict3base = manager.getContentType("org.eclipse.core.tests.resources.base_conflict3");
        IContentType conflict3sub = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict3");
        IContentType conflict3unrelated = manager.getContentType("org.eclipse.core.tests.resources.unrelated_conflict3");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict3base);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict3sub);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict3unrelated);
        Object[] selectedConflict3 = manager.findContentTypesFor(ResourceTestUtil.createRandomContentsStream(), "test.conflict3");
        Assertions.assertThat((Object[])selectedConflict3).containsExactly((Object[])new IContentType[]{conflict3sub, conflict3unrelated});
        IContentType conflict4base = manager.getContentType("org.eclipse.core.tests.resources.base_conflict4");
        IContentType conflict4sub = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict4");
        IContentType conflict4unrelated_lowPriority = manager.getContentType("org.eclipse.core.tests.resources.unrelated_conflict4");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict4base);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict4sub);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict4unrelated_lowPriority);
        Object[] selectedConflict4 = manager.findContentTypesFor(ResourceTestUtil.createRandomContentsStream(), "test.conflict4");
        Assertions.assertThat((Object[])selectedConflict4).containsExactly((Object[])new IContentType[]{conflict4sub, conflict4unrelated_lowPriority});
        IContentType conflict5base = manager.getContentType("org.eclipse.core.tests.resources.base_conflict5");
        IContentType conflict5sub_lowPriority = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict5");
        IContentType conflict5unrelated = manager.getContentType("org.eclipse.core.tests.resources.unrelated_conflict5");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict5base);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict5sub_lowPriority);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)conflict5unrelated);
        Object[] selectedConflict5 = manager.findContentTypesFor(ResourceTestUtil.createRandomContentsStream(), "test.conflict5");
        Assertions.assertThat((Object[])selectedConflict5).containsExactly((Object[])new IContentType[]{conflict5unrelated, conflict5sub_lowPriority});
    }

    @Test
    public void testFindContentType() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType single = finder.findContentTypeFor(this.getInputStream("Just a test"), this.changeCase("file.txt"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)single);
        org.junit.jupiter.api.Assertions.assertEquals((Object)textContentType, (Object)single);
        single = finder.findContentTypeFor(this.getInputStream(XML_UTF_8, StandardCharsets.UTF_8), this.changeCase("foo.xml"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)single);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlContentType, (Object)single);
        Object[] multiple = finder.findContentTypesFor(this.getInputStream(XML_UTF_8, StandardCharsets.UTF_8), null);
        Assertions.assertThat((Object[])multiple).contains((Object[])new IContentType[]{xmlContentType});
    }

    @Test
    public void testFindContentTypPredefinedRegexp() throws IOException, CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType targetContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.predefinedContentTypeWithRegexp");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)targetContentType, (String)"Target content-type not found");
        IContentType single = finder.findContentTypeFor(this.getInputStream("Just a test"), "somepredefinedContentTypeWithRegexpFile");
        org.junit.jupiter.api.Assertions.assertEquals((Object)targetContentType, (Object)single);
        single = finder.findContentTypeFor(this.getInputStream("Just a test"), "somepredefinedContentTypeWithPatternFile");
        org.junit.jupiter.api.Assertions.assertEquals((Object)targetContentType, (Object)single);
        single = finder.findContentTypeFor(this.getInputStream("Just a test"), "somepredefinedContentTypeWithWildcardsFile");
        org.junit.jupiter.api.Assertions.assertEquals((Object)targetContentType, (Object)single);
    }

    @Test
    public void testFindContentTypeUserRegexp() throws IOException, CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType single = finder.findContentTypeFor(this.getInputStream("Just a test"), "someText.unknown");
        org.junit.jupiter.api.Assertions.assertNull((Object)single, (String)"File pattern unknown at that point");
        textContentType.addFileSpec("*Text*", 16);
        try {
            single = finder.findContentTypeFor(this.getInputStream("Just a test"), "someText.unknown");
            org.junit.jupiter.api.Assertions.assertEquals((Object)textContentType, (Object)single, (String)"Text content should now match *Text* files");
        }
        finally {
            textContentType.removeFileSpec("*Text*", 16);
        }
        single = finder.findContentTypeFor(this.getInputStream("Just a test"), "someText.unknown");
        org.junit.jupiter.api.Assertions.assertNull((Object)single, (String)"File pattern unknown at that point");
    }

    @Test
    public void testImportFileAssociation() throws CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        org.junit.jupiter.api.Assertions.assertNull((Object)contentTypeManager.findContentTypeFor("*.bug122217"));
        IPreferencesService service = Platform.getPreferencesService();
        String prefs = "file_export_version=3.0\n/instance/org.eclipse.core.runtime/content-types/org.eclipse.core.runtime.xml/file-extensions=bug122217";
        IExportedPreferences exported = service.readPreferences((InputStream)new ByteArrayInputStream(prefs.getBytes()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)service.applyPreferences(exported).isOK());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)contentTypeManager.findContentTypeFor("*.bug122217"));
    }

    @Test
    public void testInvalidMarkup() throws Exception {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        Assertions.assertThat((Object[])finder.findContentTypesFor("invalid.missing.identifier")).isEmpty();
        Assertions.assertThat((Object[])finder.findContentTypesFor("invalid.missing.name")).isEmpty();
        org.junit.jupiter.api.Assertions.assertNull((Object)contentTypeManager.getContentType("org.eclipse.core.tests.resources.invalid-missing-name"));
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles(() -> {
            Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("invalid.missing.identifier")).isEmpty();
            Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("invalid.missing.name")).isEmpty();
            org.junit.jupiter.api.Assertions.assertNull((Object)contentTypeManager.getContentType("org.eclipse.bundle03.invalid-missing-name"));
            IContentType invalidDescriber = contentTypeManager.getContentType("org.eclipse.bundle03.invalid-describer");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)invalidDescriber);
            org.junit.jupiter.api.Assertions.assertEquals((Object)invalidDescriber, (Object)contentTypeManager.findContentTypeFor("invalid.describer"));
            IContentType nullContentType = contentTypeManager.findContentTypeFor(ResourceTestUtil.createRandomContentsStream(), "invalid.describer");
            org.junit.jupiter.api.Assertions.assertNull((Object)nullContentType);
            return null;
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle03"}, (TestRegistryChangeListener)listener);
    }

    @Test
    public void testIOException() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType xml = manager.getContentType("org.eclipse.core.runtime.xml");
        IContentType rootElement = manager.getContentType("org.eclipse.core.tests.resources.root-element");
        Object[] selected = manager.findContentTypesFor(this.getInputStream(XML_US_ASCII_INVALID, StandardCharsets.ISO_8859_1), "test.xml");
        Assertions.assertThat((Object[])selected).contains((Object[])new IContentType[]{xml, rootElement});
        class FakeIOException
        extends IOException {
            private static final long serialVersionUID = 1L;

            FakeIOException() {
            }

            @Override
            public String getMessage() {
                return "This exception was thrown for testing purposes";
            }
        }
        org.junit.jupiter.api.Assertions.assertThrows(FakeIOException.class, () -> {
            IContentType[] iContentTypeArray = manager.findContentTypesFor(new InputStream(){

                @Override
                public int available() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public int read() throws IOException {
                    throw new FakeIOException();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    throw new FakeIOException();
                }
            }, "test.xml");
        });
    }

    @Test
    public void testIsKindOf() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType xmlBasedDifferentExtensionContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension");
        IContentType xmlBasedSpecificNameContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-specific-name");
        IContentType binaryContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)textContentType.isKindOf(textContentType));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xmlContentType.isKindOf(textContentType));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)textContentType.isKindOf(xmlContentType));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xmlContentType.isKindOf(xmlContentType));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xmlBasedDifferentExtensionContentType.isKindOf(textContentType));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)xmlBasedDifferentExtensionContentType.isKindOf(xmlContentType));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)xmlBasedDifferentExtensionContentType.isKindOf(xmlBasedSpecificNameContentType));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)binaryContentType.isKindOf(textContentType));
    }

    @Test
    public void testListParsing() {
        Object[] list = Util.parseItems(null);
        Assertions.assertThat((Object[])list).isEmpty();
        list = Util.parseItems((String)SAMPLE_BIN2_OFFSET);
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{SAMPLE_BIN2_OFFSET});
        list = Util.parseItems((String)"foo");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{"foo"});
        list = Util.parseItems((String)",");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET});
        list = Util.parseItems((String)",foo,bar");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{SAMPLE_BIN2_OFFSET, "foo", "bar"});
        list = Util.parseItems((String)"foo,bar,");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{"foo", "bar", SAMPLE_BIN2_OFFSET});
        list = Util.parseItems((String)"foo,,bar");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{"foo", SAMPLE_BIN2_OFFSET, "bar"});
        list = Util.parseItems((String)"foo,,,bar");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{"foo", SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET, "bar"});
        list = Util.parseItems((String)",,foo,bar");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET, "foo", "bar"});
        list = Util.parseItems((String)"foo,bar,,");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{"foo", "bar", SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET});
        list = Util.parseItems((String)",,,");
        Assertions.assertThat((Object[])list).containsExactly((Object[])new String[]{SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET, SAMPLE_BIN2_OFFSET});
    }

    @Test
    public void testMyContentDescriber() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType myContent = manager.getContentType("org.eclipse.core.tests.resources.myContent");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)myContent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)myContent, (Object)manager.findContentTypeFor("myContent.mc1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)myContent, (Object)manager.findContentTypeFor("myContent.mc2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)myContent, (Object)manager.findContentTypeFor("foo.myContent1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)myContent, (Object)manager.findContentTypeFor("bar.myContent2"));
        IContentDescription description = manager.getDescriptionFor(this.getInputStream("MY_CONTENTS", StandardCharsets.US_ASCII), "myContent.mc1", IContentDescription.ALL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)myContent, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertNotSame((Object)myContent.getDefaultDescription(), (Object)description);
        int i = 0;
        while (i < MyContentDescriber.MY_OPTIONS.length) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)MyContentDescriber.MY_OPTION_VALUES[i], (Object)description.getProperty(MyContentDescriber.MY_OPTIONS[i]), (String)(SAMPLE_BIN2_OFFSET + i));
            ++i;
        }
    }

    @Test
    public void testNoExtensionAssociation() throws Exception {
        IContentTypeManager manager = Platform.getContentTypeManager();
        Object[] selected = manager.findContentTypesFor("file_with_no_extension");
        Assertions.assertThat((Object[])selected).isEmpty();
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles(() -> {
            String namespace = "org.eclipse.bundle04";
            IContentType empty1 = manager.getContentType("org.eclipse.bundle04.empty_extension1");
            IContentType empty2 = manager.getContentType("org.eclipse.bundle04.empty_extension2");
            IContentType empty3 = manager.getContentType("org.eclipse.bundle04.empty_extension3");
            IContentType empty4 = manager.getContentType("org.eclipse.bundle04.empty_extension4");
            IContentType nonEmpty = manager.getContentType("org.eclipse.bundle04.non_empty_extension");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)empty1);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)empty2);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)empty3);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)empty4);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nonEmpty);
            Object[] selected1 = manager.findContentTypesFor("file_with_no_extension");
            Assertions.assertThat((Object[])selected1).containsExactlyInAnyOrder((Object[])new IContentType[]{empty1, empty2, empty3, empty4});
            selected1 = manager.findContentTypesFor("file_with_extension.non-empty");
            Assertions.assertThat((Object[])selected1).containsExactly((Object[])new IContentType[]{nonEmpty});
            nonEmpty.addFileSpec(SAMPLE_BIN2_OFFSET, 8);
            try {
                selected1 = manager.findContentTypesFor("file_with_no_extension");
                ((ObjectArrayAssert)Assertions.assertThat((Object[])selected1).hasSize(5)).containsOnlyOnce((Object[])new IContentType[]{nonEmpty});
            }
            finally {
                nonEmpty.removeFileSpec(SAMPLE_BIN2_OFFSET, 8);
            }
            selected1 = manager.findContentTypesFor("file_with_no_extension");
            ((ObjectArrayAssert)Assertions.assertThat((Object[])selected1).hasSize(4)).doesNotContain((Object[])new IContentType[]{nonEmpty});
            return null;
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle04"}, (TestRegistryChangeListener)listener);
    }

    @Test
    public void testOrderWithEmptyFiles() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = manager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType xml = manager.getContentType("org.eclipse.core.runtime.xml");
        manager.getContentType("org.eclipse.core.tests.resources.root-element");
        manager.getContentType("org.eclipse.core.tests.resources.dtd");
        IContentType selected = finder.findContentTypeFor(this.getInputStream(SAMPLE_BIN2_OFFSET), "foo.xml");
        org.junit.jupiter.api.Assertions.assertEquals((Object)xml, (Object)selected);
        org.junit.jupiter.api.Assertions.assertEquals((Object)xml, (Object)finder.findContentTypeFor("foo.xml"));
    }

    @Test
    public void testOrphanContentType() throws Exception {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType orphan = contentTypeManager.getContentType("org.eclipse.core.tests.resources.orphan");
        org.junit.jupiter.api.Assertions.assertNull((Object)orphan);
        IContentType missing = contentTypeManager.getContentType("org.eclipse.bundle01.missing");
        org.junit.jupiter.api.Assertions.assertNull((Object)missing);
        Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("foo.orphan")).isEmpty();
        Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("orphan.orphan")).isEmpty();
        Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("foo.orphan2")).isEmpty();
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles(() -> {
            IContentType orphan1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.orphan");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)orphan1);
            IContentType missing1 = contentTypeManager.getContentType("org.eclipse.bundle01.missing");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)missing1);
            Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("foo.orphan")).containsExactly((Object[])new IContentType[]{orphan1});
            Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("orphan.orphan")).containsExactly((Object[])new IContentType[]{orphan1});
            Assertions.assertThat((Object[])contentTypeManager.findContentTypesFor("foo.orphan2")).containsExactly((Object[])new IContentType[]{missing1});
            return null;
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle01"}, (TestRegistryChangeListener)listener);
    }

    @Test
    public void testPreferences() throws CoreException, BackingStoreException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        Preferences textPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.runtime/content-types").node(text.getId());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)text);
        org.junit.jupiter.api.Assertions.assertNull((Object)text.getDefaultCharset());
        org.junit.jupiter.api.Assertions.assertNull((Object)textPrefs.get("charset", null));
        text.setDefaultCharset("UTF-8");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"UTF-8", (Object)textPrefs.get("charset", null));
        text.setDefaultCharset(null);
        org.junit.jupiter.api.Assertions.assertNull((Object)textPrefs.get("charset", null));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("xyz.foo"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("xyz.bar"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("foo.ext"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("bar.ext"));
        textPrefs.remove("file-names");
        textPrefs.remove("file-extensions");
        org.junit.jupiter.api.Assertions.assertNull((Object)textPrefs.get("file-names", null));
        org.junit.jupiter.api.Assertions.assertNull((Object)textPrefs.get("file-extensions", null));
        text.addFileSpec("foo.ext", 4);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith("foo.ext"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo.ext", (Object)textPrefs.get("file-names", null));
        text.addFileSpec("bar.ext", 4);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith("bar.ext"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo.ext,bar.ext", (Object)textPrefs.get("file-names", null));
        text.addFileSpec("foo", 8);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith("xyz.foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo", (Object)textPrefs.get("file-extensions", null));
        text.addFileSpec("bar", 8);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)text.isAssociatedWith("xyz.bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"foo,bar", (Object)textPrefs.get("file-extensions", null));
        text.removeFileSpec("foo.ext", 4);
        text.removeFileSpec("bar.ext", 4);
        text.removeFileSpec("foo", 8);
        text.removeFileSpec("bar", 8);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("xyz.foo"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("xyz.bar"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("foo.ext"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)text.isAssociatedWith("bar.ext"));
        try {
            text.addFileSpec("foo.bar", 4);
            textPrefs.sync();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"foo.bar", (Object)textPrefs.get("file-names", null));
        }
        finally {
            text.removeFileSpec("foo.bar", 4);
        }
    }

    @Test
    public void testRegistry() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)textContentType);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isText(contentTypeManager, textContentType));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)((ContentTypeHandler)textContentType).getTarget().getDescriber());
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xmlContentType);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isText(contentTypeManager, xmlContentType));
        org.junit.jupiter.api.Assertions.assertEquals((Object)textContentType, (Object)xmlContentType.getBaseType());
        IContentDescriber xmlDescriber = ((ContentTypeHandler)xmlContentType).getTarget().getDescriber();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xmlDescriber);
        Assertions.assertThat((Object)xmlDescriber).isInstanceOf(XMLContentDescriber.class);
        IContentType xmlBasedDifferentExtensionContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xmlBasedDifferentExtensionContentType);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isText(contentTypeManager, xmlBasedDifferentExtensionContentType));
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlContentType, (Object)xmlBasedDifferentExtensionContentType.getBaseType());
        IContentType xmlBasedSpecificNameContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-specific-name");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)xmlBasedSpecificNameContentType);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isText(contentTypeManager, xmlBasedSpecificNameContentType));
        org.junit.jupiter.api.Assertions.assertEquals((Object)xmlContentType, (Object)xmlBasedSpecificNameContentType.getBaseType());
        Object[] xmlTypes = finder.findContentTypesFor(this.changeCase("foo.xml"));
        Assertions.assertThat((Object[])xmlTypes).contains((Object[])new IContentType[]{xmlContentType});
        IContentType binaryContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)binaryContentType);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isText(contentTypeManager, binaryContentType));
        org.junit.jupiter.api.Assertions.assertNull((Object)binaryContentType.getBaseType());
        Object[] binaryTypes = finder.findContentTypesFor(this.changeCase("foo.samplebin1"));
        Assertions.assertThat((Object[])binaryTypes).containsExactly((Object[])new IContentType[]{binaryContentType});
        IContentType myText = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)myText);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"BAR", (Object)myText.getDefaultCharset());
        Object[] fooBarTypes = finder.findContentTypesFor(this.changeCase("foo.bar"));
        Assertions.assertThat((Object[])fooBarTypes).hasSize(2);
        IContentType fooBar = contentTypeManager.getContentType("org.eclipse.core.tests.resources.fooBar");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fooBar);
        IContentType subFooBar = contentTypeManager.getContentType("org.eclipse.core.tests.resources.subFooBar");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)subFooBar);
        Assertions.assertThat((Object[])fooBarTypes).contains((Object[])new IContentType[]{fooBar, subFooBar});
    }

    @Test
    public void testRootElementAndDTDDescriber() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType rootElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.root-element");
        IContentType dtdElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.dtd");
        IContentType nsRootElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.ns-root-element");
        IContentType nsWildcard = contentTypeManager.getContentType("org.eclipse.core.tests.resources.ns-wildcard");
        IContentType emptyNsRootElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.empty-ns-root-element");
        IContentType xmlType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        Object[] contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_ISO_8859_1, StandardCharsets.ISO_8859_1), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)rootElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_EXTERNAL_ENTITY, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)rootElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_EXTERNAL_ENTITY2, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)rootElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH1, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)nsRootElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH2, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)nsRootElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WRONG_ELEM, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)xmlType, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WRONG_NS, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)xmlType, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MIXUP, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)xmlType, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WILDCARD, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)nsWildcard, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WILDCARD2, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)nsWildcard, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_EMPTY_NS, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)emptyNsRootElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_DTD_US_ASCII, StandardCharsets.US_ASCII), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)dtdElement, Assertions.atIndex((int)0));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_DTD_EXTERNAL_ENTITY, StandardCharsets.UTF_8), "fake.xml");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)dtdElement, Assertions.atIndex((int)0));
        IContentDescription description = contentTypeManager.getDescriptionFor(this.getInputStream(new byte[][]{IContentDescription.BOM_UTF_16BE, XML_ROOT_ELEMENT_NO_DECL.getBytes("UTF-16BE")}), "fake.xml", IContentDescription.ALL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)rootElement, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)IContentDescription.BOM_UTF_16BE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = contentTypeManager.getDescriptionFor(this.getInputStream(new byte[][]{IContentDescription.BOM_UTF_16LE, XML_ROOT_ELEMENT_NO_DECL.getBytes("UTF-16LE")}), "fake.xml", IContentDescription.ALL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)rootElement, (Object)description.getContentType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)IContentDescription.BOM_UTF_16LE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NO_DECL, StandardCharsets.UTF_8), "test.txt");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])contentTypes).hasSizeGreaterThan(0)).contains((Object)contentTypeManager.getContentType("org.eclipse.core.runtime.text"), Assertions.atIndex((int)0));
    }

    @Test
    public void testSignatureBeyondBufferLimit() throws IOException {
        int bufferLimit = 4096;
        StringBuilder comment = new StringBuilder("<!--");
        int i = 0;
        while (i < bufferLimit) {
            comment.append('*');
            ++i;
        }
        comment.append("-->");
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType rootElement = manager.getContentType("org.eclipse.core.tests.resources.root-element");
        IContentType selected = manager.findContentTypeFor(this.getInputStream(String.valueOf(comment) + XML_ROOT_ELEMENT_NO_DECL, StandardCharsets.US_ASCII), "fake.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)selected);
        org.junit.jupiter.api.Assertions.assertEquals((Object)rootElement, (Object)selected);
    }

    @Test
    public void testUserDefinedAssociations() throws CoreException {
        IContentType result;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        org.junit.jupiter.api.Assertions.assertNull((Object)manager.findContentTypeFor("test.mytext"));
        text.addFileSpec("mytext", 8);
        boolean assertionFailed = false;
        try {
            try {
                result = manager.findContentTypeFor("test.mytext");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
                org.junit.jupiter.api.Assertions.assertEquals((Object)text, (Object)result);
            }
            catch (AssertionError afe) {
                assertionFailed = true;
                throw afe;
            }
        }
        finally {
            text.removeFileSpec("mytext", 8);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)assertionFailed);
        }
        result = manager.findContentTypeFor("test.mytext");
        org.junit.jupiter.api.Assertions.assertNull((Object)result);
    }

    @Test
    public void testDescriberInvalidation() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType type_bug182337_A = contentTypeManager.getContentType("org.eclipse.core.tests.resources.Bug182337_A");
        IContentType type_bug182337_B = contentTypeManager.getContentType("org.eclipse.core.tests.resources.Bug182337_B");
        Object[] contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH2, StandardCharsets.UTF_8), "Bug182337.Bug182337");
        Assertions.assertThat((Object[])contentTypes).containsExactly((Object[])new IContentType[]{type_bug182337_A, type_bug182337_B});
        InputStream is = new InputStream(){

            @Override
            public int read() {
                throw new RuntimeException();
            }
        };
        contentTypes = contentTypeManager.findContentTypesFor(is, "Bug182337.Bug182337");
        Assertions.assertThat((Object[])contentTypes).isEmpty();
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH2, StandardCharsets.UTF_8), "Bug182337.Bug182337");
        Assertions.assertThat((Object[])contentTypes).isEmpty();
    }

    private BundleContext getContext() {
        return Platform.getBundle((String)"org.eclipse.core.tests.resources").getBundleContext();
    }

    private static class ContentTypeChangeTracer
    implements IContentTypeManager.IContentTypeChangeListener {
        private final Set<IContentType> changed = new HashSet<IContentType>();

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
            this.changed.add(event.getContentType());
        }

        public boolean isOnlyChange(IContentType myType) {
            return this.changed.size() == 1 && this.changed.contains(myType);
        }

        public void reset() {
            this.changed.clear();
        }
    }
}

