/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.content.LazyInputStream;
import org.junit.jupiter.api.Test;

public class LazyInputStreamTest {
    private static final String DATA = "012345678901234567890123456789";
    private static final int[] VARIOUS_INTS;

    static {
        int[] nArray = new int[7];
        nArray[0] = 255;
        nArray[1] = 254;
        nArray[2] = 160;
        nArray[3] = 127;
        nArray[4] = 112;
        nArray[5] = 16;
        VARIOUS_INTS = nArray;
    }

    @Test
    public void testReadSingleByte() throws IOException {
        ByteArrayInputStream underlying = new ByteArrayInputStream(DATA.getBytes());
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        org.junit.jupiter.api.Assertions.assertEquals((int)48, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((int)49, (int)stream.read());
        stream.skip(10L);
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        stream.close();
    }

    @Test
    public void testReadBlock() throws IOException {
        ByteArrayInputStream underlying = new ByteArrayInputStream(DATA.getBytes());
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        stream.skip(4L);
        byte[] buffer = new byte[7];
        int read = stream.read(buffer);
        Assertions.assertThat((byte[])buffer).hasSize(read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(4, 4 + buffer.length), (Object)new String(buffer));
        org.junit.jupiter.api.Assertions.assertEquals((long)11L, (long)stream.getOffset());
        read = stream.read(buffer, 3, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(11, 11 + read), (Object)new String(buffer, 3, read));
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)stream.getOffset());
        stream.mark(0);
        buffer = new byte[100];
        read = stream.read(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((int)(DATA.length() - 15), (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(15, 15 + read), (Object)new String(buffer, 0, read));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stream.available());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)stream.getOffset());
        read = stream.read(buffer, 10, 14);
        org.junit.jupiter.api.Assertions.assertEquals((long)29L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)stream.available());
        org.junit.jupiter.api.Assertions.assertEquals((int)14, (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(15, 15 + read), (Object)new String(buffer, 10, read));
        read = stream.read(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((long)30L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stream.available());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((byte)((byte)DATA.charAt(29)), (byte)buffer[0]);
        read = stream.read(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((long)30L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)stream.available());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)read);
        stream.close();
    }

    @Test
    public void testMarkAndReset() throws IOException {
        ByteArrayInputStream underlying = new ByteArrayInputStream(DATA.getBytes());
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        org.junit.jupiter.api.Assertions.assertEquals((int)30, (int)stream.available());
        stream.skip(13L);
        org.junit.jupiter.api.Assertions.assertEquals((int)17, (int)stream.available());
        stream.mark(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getMark());
        org.junit.jupiter.api.Assertions.assertEquals((int)51, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((int)52, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)stream.available());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertEquals((int)17, (int)stream.available());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertEquals((int)17, (int)stream.available());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        stream.rewind();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)stream.getOffset());
        stream.close();
    }

    @Test
    public void testContentHasEOF() throws IOException {
        byte[] changedData = DATA.getBytes();
        changedData[0] = -1;
        ByteArrayInputStream underlying = new ByteArrayInputStream(changedData);
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        int c = stream.read();
        org.junit.jupiter.api.Assertions.assertNotEquals((int)-1, (int)c);
        org.junit.jupiter.api.Assertions.assertEquals((int)255, (int)c);
        stream.close();
    }

    @Test
    public void testVariedContent() throws IOException {
        byte[] contents = new byte[VARIOUS_INTS.length];
        int i = 0;
        while (i < contents.length) {
            contents[i] = (byte)VARIOUS_INTS[i];
            ++i;
        }
        ByteArrayInputStream underlying = new ByteArrayInputStream(contents);
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        int i2 = 0;
        while (i2 < VARIOUS_INTS.length) {
            org.junit.jupiter.api.Assertions.assertEquals((int)VARIOUS_INTS[i2], (int)stream.read(), (String)("" + i2));
            ++i2;
        }
        stream.close();
    }

    @Test
    public void testEnsureAvailable_BufferSizeDoesNotOverflow() throws IOException {
        InputStream infinitelyEmpty = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return len;
            }
        };
        Throwable throwable = null;
        Object var3_4 = null;
        try (OpenLazyInputStream objectUnderTest = new OpenLazyInputStream(infinitelyEmpty, 10);){
            objectUnderTest.setBufferSize(Integer.MAX_VALUE);
            objectUnderTest.setOffset(Integer.MAX_VALUE);
            objectUnderTest.skip(1L);
            org.junit.jupiter.api.Assertions.assertTrue((objectUnderTest.getBufferSize() > Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The buffer size suffered an Overflow");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class OpenLazyInputStream
    extends LazyInputStream {
        public OpenLazyInputStream(InputStream in, int blockCapacity) {
            super(in, blockCapacity);
        }

        public int getBlockCount() {
            return super.getBlockCount();
        }

        public long getBufferSize() {
            return super.getBufferSize();
        }

        public void setBufferSize(long bufferSize) {
            super.setBufferSize(bufferSize);
        }

        public long getMark() {
            return super.getMark();
        }

        public long getOffset() {
            return super.getOffset();
        }

        protected void setOffset(long offset) {
            super.setOffset(offset);
        }
    }
}

