/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.content.LazyReader;
import org.junit.jupiter.api.Test;

public class LazyReaderTest {
    private static final String DATA = "012345678901234567890123456789";

    @Test
    public void testReadSingleChar() throws IOException {
        CharArrayReader underlying = new CharArrayReader(DATA.toCharArray());
        OpenLazyReader stream = new OpenLazyReader(underlying, 7);
        org.junit.jupiter.api.Assertions.assertEquals((int)48, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((int)49, (int)stream.read());
        stream.skip(10L);
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        stream.close();
    }

    @Test
    public void testReadBlock() throws IOException {
        CharArrayReader underlying = new CharArrayReader(DATA.toCharArray());
        OpenLazyReader stream = new OpenLazyReader(underlying, 7);
        stream.skip(4L);
        char[] buffer = new char[7];
        int read = stream.read(buffer);
        Assertions.assertThat((char[])buffer).hasSize(read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(4, 4 + buffer.length), (Object)new String(buffer));
        org.junit.jupiter.api.Assertions.assertEquals((long)11L, (long)stream.getOffset());
        read = stream.read(buffer, 3, 4);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(11, 11 + read), (Object)new String(buffer, 3, read));
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)stream.getOffset());
        stream.mark(0);
        buffer = new char[100];
        read = stream.read(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((int)(DATA.length() - 15), (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(15, 15 + read), (Object)new String(buffer, 0, read));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stream.ready());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)stream.getOffset());
        read = stream.read(buffer, 10, 14);
        org.junit.jupiter.api.Assertions.assertEquals((long)29L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        org.junit.jupiter.api.Assertions.assertEquals((int)14, (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((Object)DATA.substring(15, 15 + read), (Object)new String(buffer, 10, read));
        read = stream.read(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((long)30L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stream.ready());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)read);
        org.junit.jupiter.api.Assertions.assertEquals((int)((byte)DATA.charAt(29)), (int)buffer[0]);
        read = stream.read(buffer);
        org.junit.jupiter.api.Assertions.assertEquals((long)30L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stream.ready());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)read);
        stream.close();
    }

    @Test
    public void testMarkAndReset() throws IOException {
        CharArrayReader underlying = new CharArrayReader(DATA.toCharArray());
        OpenLazyReader stream = new OpenLazyReader(underlying, 7);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        stream.skip(13L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        stream.mark(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getMark());
        org.junit.jupiter.api.Assertions.assertEquals((int)51, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((int)52, (int)stream.read());
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        org.junit.jupiter.api.Assertions.assertEquals((long)17L, (long)stream.skip(1000L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stream.ready());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        stream.reset();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.ready());
        org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)stream.getOffset());
        stream.rewind();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)stream.getOffset());
        stream.close();
    }

    @Test
    public void testEnsureAvailable_BufferSizeDoesNotOverflow() throws IOException {
        Reader infinitelyEmpty = new Reader(){

            @Override
            public int read() throws IOException {
                return 0;
            }

            @Override
            public int read(char[] b, int off, int len) throws IOException {
                return len;
            }

            @Override
            public void close() throws IOException {
            }
        };
        Throwable throwable = null;
        Object var3_4 = null;
        try (OpenLazyReader objectUnderTest = new OpenLazyReader(infinitelyEmpty, 10);){
            objectUnderTest.setBufferSize(Integer.MAX_VALUE);
            objectUnderTest.setOffset(Integer.MAX_VALUE);
            objectUnderTest.skip(1L);
            org.junit.jupiter.api.Assertions.assertTrue((objectUnderTest.getBufferSize() > Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The buffer size suffered an Overflow");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class OpenLazyReader
    extends LazyReader {
        public OpenLazyReader(Reader in, int blockCapacity) {
            super(in, blockCapacity);
        }

        public int getBlockCount() {
            return super.getBlockCount();
        }

        public long getBufferSize() {
            return super.getBufferSize();
        }

        protected void setBufferSize(long bufferSize) {
            super.setBufferSize(bufferSize);
        }

        public long getMark() {
            return super.getMark();
        }

        public long getOffset() {
            return super.getOffset();
        }

        protected void setOffset(long offset) {
            super.setOffset(offset);
        }
    }
}

