/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.tests.resources.content.LocalSelectionPolicy;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class SpecificContextTest {
    @Test
    public void testContentTypeLookup(TestInfo testInfo) throws CoreException {
        String testName = testInfo.getDisplayName();
        IContentTypeManager global = Platform.getContentTypeManager();
        SingleNodeScope scope = new SingleNodeScope();
        IContentTypeMatcher local = global.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), (IScopeContext)scope);
        IContentType textContentType = global.getContentType("org.eclipse.core.runtime.text");
        textContentType.addFileSpec(testName + ".global", 4);
        textContentType.getSettings((IScopeContext)scope).addFileSpec(testName + ".local", 4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)textContentType, (Object)global.findContentTypeFor(testName + ".global"));
        org.junit.jupiter.api.Assertions.assertNull((Object)local.findContentTypeFor(testName + ".global"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)textContentType, (Object)local.findContentTypeFor(testName + ".local"));
        org.junit.jupiter.api.Assertions.assertNull((Object)global.findContentTypeFor(testName + ".local"));
        textContentType.removeFileSpec(testName + ".global", 4);
    }

    @Test
    public void testIsAssociatedWith() throws CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        SingleNodeScope scope = new SingleNodeScope();
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeSettings localSettings = null;
        localSettings = textContentType.getSettings((IScopeContext)scope);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)textContentType.isAssociatedWith("hello.foo", (IScopeContext)scope));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)textContentType.isAssociatedWith("hello.foo"));
        localSettings.addFileSpec("foo", 8);
        localSettings = textContentType.getSettings((IScopeContext)scope);
        Object[] fileSpecs = localSettings.getFileSpecs(8);
        Assertions.assertThat((Object[])fileSpecs).containsExactly((Object[])new String[]{"foo"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)textContentType.isAssociatedWith("hello.foo", (IScopeContext)scope));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)textContentType.isAssociatedWith("hello.foo"));
    }

    private static class SingleNodeScope
    implements IScopeContext {
        private final IEclipsePreferences node = new EclipsePreferences();

        SingleNodeScope() {
        }

        public IPath getLocation() {
            return null;
        }

        public String getName() {
            return "";
        }

        public IEclipsePreferences getNode(String qualifier) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"org.eclipse.core.runtime/content-types", (Object)qualifier);
            return this.node;
        }
    }
}

