/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLContentDescriberTest {
    private static final String ENCODED_TEXT = "\u1000\u20001\u3000\u4000\u5000\u6000\u7000\u8000\u9000\ua000";
    private static final String ENCODING_UTF16 = "UTF-16";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String ENCODING_NOTSUPPORTED = "ENCODING_NOTSUPPORTED";
    private static final String ENCODING_INCORRECT = "<?ENCODING?>";
    private static final String ENCODING_EMPTY = "";
    private static final String WHITESPACE_CHARACTERS = " \t\n\r";

    @Test
    public void testEncodedContents1() throws Exception {
        this.checkEncodedContents(ENCODING_UTF16, ENCODING_UTF16, ENCODING_UTF16);
        this.checkEncodedContents(ENCODING_UTF8, ENCODING_UTF8, ENCODING_UTF8);
        this.checkEncodedContents(ENCODING_UTF16, ENCODING_UTF16, ENCODING_UTF8);
        this.checkEncodedContents(ENCODING_UTF8, ENCODING_UTF8, ENCODING_UTF16);
        this.checkEncodedContents(ENCODING_NOTSUPPORTED, ENCODING_NOTSUPPORTED, ENCODING_UTF8);
        this.checkEncodedContents(ENCODING_NOTSUPPORTED, ENCODING_NOTSUPPORTED, ENCODING_UTF16);
    }

    @Test
    public void testEncodedContents2() throws Exception {
        this.checkEncodedContents2(ENCODING_UTF16, ENCODING_UTF16);
        this.checkEncodedContents2(ENCODING_UTF8, ENCODING_UTF8);
        this.checkEncodedContents2(ENCODING_NOTSUPPORTED, ENCODING_NOTSUPPORTED);
    }

    @Test
    public void testEncodedContents3() throws Exception {
        boolean[] flag;
        boolean[][] blArrayArray = new boolean[8][];
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[3];
        blArray2[0] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[3];
        blArray3[1] = true;
        blArrayArray[2] = blArray3;
        blArrayArray[3] = new boolean[3];
        blArrayArray[4] = new boolean[]{true, true, true};
        boolean[] blArray4 = new boolean[3];
        blArray4[0] = true;
        blArray4[2] = true;
        blArrayArray[5] = blArray4;
        boolean[] blArray5 = new boolean[3];
        blArray5[1] = true;
        blArray5[2] = true;
        blArrayArray[6] = blArray5;
        boolean[] blArray6 = new boolean[3];
        blArray6[2] = true;
        blArrayArray[7] = blArray6;
        boolean[][] flags = blArrayArray;
        IContentDescription description = null;
        boolean[][] blArrayArray2 = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            flag = blArrayArray2[n2];
            description = Platform.getContentTypeManager().getDescriptionFor(this.getInputStream(ENCODING_INCORRECT, ENCODING_UTF8, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNull((Object)description);
            description = Platform.getContentTypeManager().getDescriptionFor(this.getInputStream(ENCODING_INCORRECT, ENCODING_UTF16, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNull((Object)description);
            description = Platform.getContentTypeManager().getDescriptionFor(this.getReader(ENCODING_INCORRECT, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNull((Object)description);
            ++n2;
        }
        blArrayArray2 = flags;
        n = flags.length;
        n2 = 0;
        while (n2 < n) {
            flag = blArrayArray2[n2];
            description = Platform.getContentTypeManager().getDescriptionFor(this.getInputStream(ENCODING_EMPTY, ENCODING_UTF8, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNull((Object)description);
            description = Platform.getContentTypeManager().getDescriptionFor(this.getInputStream(ENCODING_EMPTY, ENCODING_UTF16, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNull((Object)description);
            description = Platform.getContentTypeManager().getDescriptionFor(this.getReader(ENCODING_EMPTY, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNull((Object)description);
            ++n2;
        }
    }

    @Test
    public void testBug258208() throws Exception {
        IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(this.getInputStream(ENCODING_EMPTY, ENCODING_UTF8, false, true, false), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
        Assertions.assertNull((Object)description);
        this.checkEncodedContents(ENCODING_UTF16, ENCODING_UTF16, ENCODING_UTF16);
    }

    private void checkEncodedContents(String expectedEncoding, String encodingInContent, String encoding) throws Exception {
        boolean[][] blArrayArray = new boolean[8][];
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[3];
        blArray2[0] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[3];
        blArray3[1] = true;
        blArrayArray[2] = blArray3;
        blArrayArray[3] = new boolean[3];
        blArrayArray[4] = new boolean[]{true, true, true};
        boolean[] blArray4 = new boolean[3];
        blArray4[0] = true;
        blArray4[2] = true;
        blArrayArray[5] = blArray4;
        boolean[] blArray5 = new boolean[3];
        blArray5[1] = true;
        blArray5[2] = true;
        blArrayArray[6] = blArray5;
        boolean[] blArray6 = new boolean[3];
        blArray6[2] = true;
        blArrayArray[7] = blArray6;
        boolean[][] flags = blArrayArray;
        IContentDescription description = null;
        boolean[][] blArrayArray2 = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] flag = blArrayArray2[n2];
            description = Platform.getContentTypeManager().getDescriptionFor(this.getInputStream(encodingInContent, encoding, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNotNull((Object)description, (String)Arrays.toString(flag));
            Assertions.assertEquals((Object)"org.eclipse.core.runtime.xml", (Object)description.getContentType().getId(), (String)Arrays.toString(flag));
            Assertions.assertEquals((Object)expectedEncoding, (Object)description.getProperty(IContentDescription.CHARSET), (String)Arrays.toString(flag));
            ++n2;
        }
    }

    private void checkEncodedContents2(String expectedEncoding, String encodingInContent) throws Exception {
        boolean[][] blArrayArray = new boolean[8][];
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[3];
        blArray2[0] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[3];
        blArray3[1] = true;
        blArrayArray[2] = blArray3;
        blArrayArray[3] = new boolean[3];
        blArrayArray[4] = new boolean[]{true, true, true};
        boolean[] blArray4 = new boolean[3];
        blArray4[0] = true;
        blArray4[2] = true;
        blArrayArray[5] = blArray4;
        boolean[] blArray5 = new boolean[3];
        blArray5[1] = true;
        blArray5[2] = true;
        blArrayArray[6] = blArray5;
        boolean[] blArray6 = new boolean[3];
        blArray6[2] = true;
        blArrayArray[7] = blArray6;
        boolean[][] flags = blArrayArray;
        IContentDescription description = null;
        boolean[][] blArrayArray2 = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] flag = blArrayArray2[n2];
            description = Platform.getContentTypeManager().getDescriptionFor(this.getReader(encodingInContent, flag[0], flag[1], flag[2]), "fake.xml", new QualifiedName[]{IContentDescription.CHARSET});
            Assertions.assertNotNull((Object)description, (String)Arrays.toString(flag));
            Assertions.assertEquals((Object)"org.eclipse.core.runtime.xml", (Object)description.getContentType().getId(), (String)Arrays.toString(flag));
            Assertions.assertEquals((Object)expectedEncoding, (Object)description.getProperty(IContentDescription.CHARSET), (String)Arrays.toString(flag));
            ++n2;
        }
    }

    private InputStream getInputStream(String encodingInContent, String encoding, boolean encInNewLine, boolean encClosed, boolean whitespace) throws UnsupportedEncodingException {
        String content = "<?xml version=\"1.0\"" + (encInNewLine ? "\n" : ENCODING_EMPTY) + "encoding" + (whitespace ? WHITESPACE_CHARACTERS : ENCODING_EMPTY) + "=" + (whitespace ? WHITESPACE_CHARACTERS : ENCODING_EMPTY) + "\"" + encodingInContent + (encClosed ? "\"" : ENCODING_EMPTY) + "?><root attribute=\"\u1000\u20001\u3000\u4000\u5000\u6000\u7000\u8000\u9000\ua000\">";
        return new ByteArrayInputStream(content.getBytes(encoding));
    }

    private Reader getReader(String encodingInContent, boolean encInNewLine, boolean encClosed, boolean whitespace) {
        String content = "<?xml version=\"1.0\"" + (encInNewLine ? "\n" : ENCODING_EMPTY) + "encoding" + (whitespace ? WHITESPACE_CHARACTERS : ENCODING_EMPTY) + "=" + (whitespace ? WHITESPACE_CHARACTERS : ENCODING_EMPTY) + "\"" + encodingInContent + (encClosed ? "\"" : ENCODING_EMPTY) + "?><root attribute=\"\u1000\u20001\u3000\u4000\u5000\u6000\u7000\u8000\u9000\ua000\">";
        return new InputStreamReader(new ByteArrayInputStream(content.getBytes()));
    }
}

