/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.ArrayList;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class BenchElementTree {
    @Rule
    public TestName testName = new TestName();
    static String[] javaLangUnits = new String[]{"AbstractMethodError.java", "ArithmeticException.java", "ArrayIndexOutOfBoundsException.java", "ArrayStoreException.java", "Boolean.java", "Byte.java", "Character.java", "Class.java", "ClassCastException.java", "ClassCircularityError.java", "ClassFormatError.java", "ClassLoader.java", "ClassNotFoundException.java", "Cloneable.java", "CloneNotSupportedException.java", "Compiler.java", "Double.java", "Error.java", "Exception.java", "ExceptionInInitializerError.java", "Float.java", "FloatingDecimal.java", "IllegalAccessError.java", "IllegalAccessException.java", "IllegalArgumentException.java", "IllegalMonitorStateException.java", "IllegalStateException.java", "IllegalThreadStateException.java", "IncompatibleClassChangeError.java", "IndexOutOfBoundsException.java", "InstantiationError.java", "InstantiationException.java", "Integer.java", "InternalError.java", "InterruptedException.java", "LinkageError.java", "Long.java", "Math.java", "NegativeArraySizeException.java", "NoClassDefFoundError.java", "NoSuchFieldError.java", "NoSuchFieldException.java", "NoSuchMethodError.java", "NoSuchMethodException.java", "NullPointerException.java", "Number.java", "NumberFormatException.java", "Object.java", "OutOfMemoryError.java", "Process.java", "Runnable.java", "Runtime.java", "RuntimeException.java", "SecurityException.java", "SecurityManager.java", "Short.java", "StackOverflowError.java", "String.java", "StringBuilder.java", "StringIndexOutOfBoundsException.java", "System.java", "Thread.java", "ThreadDeath.java", "ThreadGroup.java", "Throwable.java", "UnknownError.java", "UnsatisfiedLinkError.java", "VerifyError.java", "VirtualMachineError.java", "Void.java"};
    static final IPath solution = IPath.ROOT.append("solution");
    static final IPath project = solution.append("project");
    static final IPath folder = project.append("folder");
    static final IPath[] files = BenchElementTree.getFilePaths();

    @Test
    public void testCreateElement() throws Exception {
        new PerformanceTestRunner(){

            protected void test() {
                BenchElementTree.this.createTestTree(false);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 400);
    }

    @Test
    public void testDeleteElement() throws Exception {
        int repeat = 400;
        final ElementTree[] trees = new ElementTree[400];
        int i = 0;
        while (i < 400) {
            trees[i] = this.createTestTree(false);
            ++i;
        }
        new PerformanceTestRunner(){
            int rep = 0;

            protected void test() {
                IPath[] iPathArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath file = iPathArray[n2];
                    trees[this.rep].deleteElement(file);
                    ++n2;
                }
                ++this.rep;
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 400);
    }

    @Test
    public void testGetElementData() throws Exception {
        final ElementTree tree = this.createTestTree(false);
        new PerformanceTestRunner(){

            protected void test() {
                IPath[] iPathArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath file = iPathArray[n2];
                    tree.getElementData(file);
                    ++n2;
                }
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 500);
    }

    @Test
    public void testMergeDeltaChain() throws Exception {
        int repeat = 50;
        final ElementTree[] bases = new ElementTree[50];
        final ElementTree[][] chains = new ElementTree[50][];
        int i = 0;
        while (i < 50) {
            bases[i] = this.createTestTree(true);
            chains[i] = this.buildDeltaChain(this.createTestTree(false));
            ++i;
        }
        new PerformanceTestRunner(){
            int rep = 0;

            protected void test() {
                bases[this.rep].mergeDeltaChain(folder, chains[this.rep]);
                ++this.rep;
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 50);
    }

    @Test
    public void testRoutineOperations() throws Exception {
        new PerformanceTestRunner(){

            protected void test() {
                BenchElementTree.this.doRoutineOperations();
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 75);
    }

    @Test
    public void testSetElementData() throws Exception {
        final ElementTree tree = this.createTestTree(false);
        final Object data = new Object();
        new PerformanceTestRunner(){

            protected void test() {
                IPath[] iPathArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath file = iPathArray[n2];
                    tree.setElementData(file, data);
                    ++n2;
                }
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 500);
    }

    private ElementTree[] buildDeltaChain(ElementTree tree) {
        IPath[] filePaths;
        ArrayList<ElementTree> trees = new ArrayList<ElementTree>();
        trees.add(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] iPathArray = filePaths = BenchElementTree.getFilePaths();
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath filePath = iPathArray[n2];
            String data = filePath.toString();
            tree.createElement(filePath, (Object)data);
            tree.immutable();
            trees.add(tree);
            tree = tree.newEmptyDelta();
            ++n2;
        }
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            IPath[] iPathArray2 = filePaths;
            int n3 = filePaths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath filePath = iPathArray2[n4];
                tree.setElementData(filePath, (Object)data);
                tree.immutable();
                trees.add(tree);
                tree = tree.newEmptyDelta();
                ++n4;
            }
            ++i;
        }
        iPathArray = filePaths;
        n = filePaths.length;
        int n5 = 0;
        while (n5 < n) {
            IPath filePath = iPathArray[n5];
            tree.deleteElement(filePath);
            tree.immutable();
            trees.add(tree);
            tree = tree.newEmptyDelta();
            ++n5;
        }
        ElementTree[] results = new ElementTree[trees.size()];
        trees.toArray(results);
        return results;
    }

    ElementTree createTestTree(boolean withDeltas) {
        ElementTree tree = new ElementTree();
        Object data = new Object();
        tree.createElement(solution, data);
        if (withDeltas) {
            tree.immutable();
            tree = tree.newEmptyDelta();
        }
        tree.createElement(project, data);
        if (withDeltas) {
            tree.immutable();
            tree = tree.newEmptyDelta();
        }
        tree.createElement(folder, data);
        String[] stringArray = javaLangUnits;
        int n = javaLangUnits.length;
        int n2 = 0;
        while (n2 < n) {
            String javaLangUnit = stringArray[n2];
            if (withDeltas) {
                tree.immutable();
                tree = tree.newEmptyDelta();
            }
            IPath file = folder.append(javaLangUnit);
            tree.createElement(file, data);
            ++n2;
        }
        return tree;
    }

    private int doRoutineOperations() {
        ElementTree tree = this.createTestTree(true);
        int repeat = 1;
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            IPath[] iPathArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IPath file = iPathArray[n2];
                tree = tree.newEmptyDelta();
                tree.setElementData(file, (Object)data);
                tree.immutable();
                ++n2;
            }
            ++i;
        }
        IPath[] iPathArray = files;
        int n = files.length;
        int n3 = 0;
        while (n3 < n) {
            IPath file = iPathArray[n3];
            tree = tree.newEmptyDelta();
            tree.deleteElement(file);
            tree.immutable();
            ++n3;
        }
        return (repeat + 2) * files.length;
    }

    static IPath[] getFilePaths() {
        IPath[] jcuIDs = new IPath[javaLangUnits.length];
        int i = 0;
        int len = javaLangUnits.length;
        while (i < len) {
            jcuIDs[i] = folder.append(javaLangUnits[i]);
            ++i;
        }
        return jcuIDs;
    }
}

