/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.io.IOException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFileNativesManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.rules.TestName;

public class BenchFileStore {
    @Rule
    public TestName testName = new TestName();
    private static final int LOOP_SIZE = 5000;
    private static final int REPEATS = 300;

    @Test
    public void testStoreExitsNative() throws Throwable {
        BenchFileStore.withNatives(true, () -> new StoreTestRunner(true).run(this.getClass(), this.testName.getMethodName(), 300, 5000));
    }

    @Test
    public void testStoreNotExitsNative() throws Throwable {
        BenchFileStore.withNatives(true, () -> new StoreTestRunner(false).run(this.getClass(), this.testName.getMethodName(), 300, 5000));
    }

    @Test
    public void testStoreExitsNio() throws Throwable {
        BenchFileStore.withNatives(false, () -> new StoreTestRunner(true).run(this.getClass(), this.testName.getMethodName(), 300, 5000));
    }

    @Test
    public void testStoreNotExitsNio() throws Throwable {
        BenchFileStore.withNatives(false, () -> new StoreTestRunner(false).run(this.getClass(), this.testName.getMethodName(), 300, 5000));
    }

    private static void withNatives(boolean natives, ThrowingRunnable runnable) throws Throwable {
        try {
            Assert.assertEquals((String)"can't set natives to the desired value", (Object)natives, (Object)LocalFileNativesManager.setUsingNative((boolean)natives));
            runnable.run();
        }
        finally {
            LocalFileNativesManager.reset();
        }
    }

    class StoreTestRunner
    extends PerformanceTestRunner {
        private final boolean exits;
        protected IFileStore store;

        public StoreTestRunner(boolean exits) {
            this.exits = exits;
        }

        protected void setUp() throws CoreException {
            this.store = EFS.getFileSystem((String)"file").getStore(FileSystemHelper.getRandomLocation());
            if (this.exits) {
                try {
                    this.store.openOutputStream(0, null).close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("setting up store failed", e);
                }
            }
        }

        protected void tearDown() throws CoreException {
            this.store.delete(0, null);
        }

        protected void test() {
            IFileInfo info = this.store.fetchInfo();
            if (info.exists()) {
                info.getAttribute(2);
                info.getLastModified();
            }
        }
    }
}

