/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class BenchWorkspace {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final int FILES_PER_FOLDER = 20;
    private static final int NUM_FOLDERS = 400;
    IProject project;

    private void addProblems(int problemCount) throws CoreException {
        IWorkspaceRunnable runnable = monitor -> ResourcesPlugin.getWorkspace().getRoot().accept(resource -> {
            int i = 0;
            while (i < problemCount) {
                IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 1);
                ++i;
            }
            return true;
        });
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public String[] defineHierarchy() {
        String[] names = new String[8400];
        int MAX_DEPTH = 10;
        int MAX_SPAN = 40;
        int i = 0;
        int depth = 0;
        while (depth < 10) {
            int span = 0;
            while (span < 40) {
                names[i] = depth == 0 ? "TestProject/" + span + "/" : names[i - 40] + span + "/";
                ++i;
                ++span;
            }
            ++depth;
        }
        int folder = 0;
        while (folder < 400) {
            int file = 0;
            while (file < 20) {
                names[i++] = names[folder] + "file" + file;
                ++file;
            }
            ++folder;
        }
        return names;
    }

    int findMaxProblemSeverity(IWorkspaceRoot root) throws CoreException {
        class ResourceVisitor
        implements IResourceVisitor {
            int maxSeverity = -1;

            ResourceVisitor() {
            }

            public boolean visit(IResource resource) throws CoreException {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    int severity = marker.getAttribute("severity", -1);
                    if (severity > this.maxSeverity) {
                        this.maxSeverity = severity;
                    }
                    ++n2;
                }
                return true;
            }
        }
        ResourceVisitor visitor = new ResourceVisitor();
        root.accept((IResourceVisitor)visitor);
        return visitor.maxSeverity;
    }

    int findMaxProblemSeverity2(IWorkspaceRoot root) throws CoreException {
        return root.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
    }

    @Before
    public void setUp() throws Exception {
        IWorkspaceRunnable runnable = monitor -> {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestProject");
            this.project.create(null);
            this.project.open(null);
            IResource[] resources = ResourceTestUtil.buildResources((IContainer)this.project, this.defineHierarchy());
            ResourceTestUtil.createInWorkspace(resources);
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    @Test
    public void testCountResources() throws Exception {
        final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        new PerformanceTestRunner(){

            protected void setUp() throws Exception {
                super.setUp();
                BenchWorkspace.this.waitForBackgroundActivity();
            }

            protected void test() {
                workspace.countResources(root.getFullPath(), 2, true);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 100);
    }

    public void waitForBackgroundActivity() {
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.waitForBuild();
    }

    @Test
    public void testCountResourcesDuringOperation() throws Exception {
        final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = monitor -> {
            workspace.getRoot().accept(resource -> {
                resource.touch(null);
                return true;
            });
            try {
                new PerformanceTestRunner(){

                    protected void test() {
                        workspace.countResources(BenchWorkspace.this.project.getFullPath(), 2, true);
                    }
                }.run(this.getClass(), this.testName.getMethodName(), 10, 10);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, this.getClass(), "exception during performance test", (Throwable)e));
            }
        };
        workspace.run(runnable, ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testFindMaxProblemSeverity() throws Exception {
        this.addProblems(10);
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                BenchWorkspace.this.findMaxProblemSeverity2(root);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 100);
    }
}

