/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.perf.WorkspacePerformanceTest;
import org.junit.Before;

public class BuilderPerformanceTest
extends WorkspacePerformanceTest {
    private static final int PROJECT_COUNT = 100;
    private static final int REPEAT = 20;
    IProject[] otherProjects;

    void createAndPopulateProject(IProject project, IFolder folder, int totalResources) throws CoreException {
        ResourcesPlugin.getWorkspace().run(monitor -> {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Builder1"), this.createCommand(desc, "Builder2"), this.createCommand(desc, "Builder3"), this.createCommand(desc, "Builder4"), this.createCommand(desc, "Builder5")});
            project.create(desc, ResourceTestUtil.createTestMonitor());
            project.open(ResourceTestUtil.createTestMonitor());
            this.createFolder(folder, totalResources);
        }, ResourceTestUtil.createTestMonitor());
    }

    protected ICommand createCommand(IProjectDescription description, String buildID) {
        return this.createCommand(description, "org.eclipse.core.tests.resources.sortbuilder", buildID);
    }

    protected ICommand createCommand(IProjectDescription description, String builderName, String buildID) {
        ICommand command = description.newCommand();
        Map args = command.getArguments();
        args.put("BuildID", buildID);
        command.setBuilderName(builderName);
        command.setArguments(args);
        return command;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.otherProjects = new IProject[100];
        int i = 0;
        while (i < this.otherProjects.length) {
            this.otherProjects[i] = ResourcesPlugin.getWorkspace().getRoot().getProject("Project " + i);
            IFolder folder = this.otherProjects[i].getFolder("Folder");
            this.createAndPopulateProject(this.otherProjects[i], folder, 100);
            ++i;
        }
    }

    public void testManualBuildWithAutobuildOn() throws Exception {
        PerformanceTestRunner runner = new PerformanceTestRunner(){
            IProject[] projects;

            protected void setUp() {
                BuilderPerformanceTest.this.waitForBackgroundActivity();
                this.projects = ResourcesPlugin.getWorkspace().computeProjectOrder((IProject[])ResourcesPlugin.getWorkspace().getRoot().getProjects()).projects;
            }

            protected void tearDown() {
            }

            protected void test() throws CoreException {
                int repeats = 0;
                while (repeats < 20) {
                    IProject[] iProjectArray = this.projects;
                    int n = this.projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        project.build(10, ResourceTestUtil.createTestMonitor());
                        ++n2;
                    }
                    ++repeats;
                }
            }
        };
        runner.setFingerprintName("Build workspace before launch");
        runner.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }
}

