/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ContentDescriptionPerformanceTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String DEFAULT_DESCRIPTION_FILE_NAME = "default.xml";
    private static final String NO_DESCRIPTION_FILE_NAME = "none.some-uncommon-file-extension";
    private static final String NON_DEFAULT_DESCRIPTION_FILE_NAME = "specific.xml";
    private static final int SUBDIRS = 200;
    private static final int TOTAL_FILES = 5000;
    private static final Set<String> IGNORED_FILES = Set.of(".project", "org.eclipse.core.resources.prefs");
    private static final String VALID_XML_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><some-uncommon-root-element/>";
    private static final String VALID_XML_CONTENTS_WITH_NON_DEFAULT_ENCODING = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><some-uncommon-root-element/>";

    private static String getFileName(int number) {
        switch (number %= 3) {
            case 0: {
                return DEFAULT_DESCRIPTION_FILE_NAME;
            }
            case 1: {
                return NON_DEFAULT_DESCRIPTION_FILE_NAME;
            }
        }
        return NO_DESCRIPTION_FILE_NAME;
    }

    void assertHasExpectedDescription(String fileName, IContentDescription description) {
        if (fileName.endsWith(DEFAULT_DESCRIPTION_FILE_NAME)) {
            Assert.assertTrue((String)("description for " + fileName), (description == description.getContentType().getDefaultDescription() ? 1 : 0) != 0);
        } else if (fileName.endsWith(NON_DEFAULT_DESCRIPTION_FILE_NAME)) {
            Assert.assertTrue((String)("description for " + fileName), (description != description.getContentType().getDefaultDescription() ? 1 : 0) != 0);
        } else {
            Assert.assertNull((String)("description for " + fileName), (Object)description);
        }
    }

    void createFiles() throws CoreException {
        IProject bigProject = ResourcesPlugin.getWorkspace().getRoot().getProject("bigproject");
        Assert.assertTrue((String)"1.0", (!bigProject.exists() ? 1 : 0) != 0);
        bigProject.create(ResourceTestUtil.createTestMonitor());
        bigProject.open(ResourceTestUtil.createTestMonitor());
        int i = 0;
        while (i < 200) {
            IFolder folder = bigProject.getFolder("folder_" + i);
            folder.create(false, true, ResourceTestUtil.createTestMonitor());
            int j = 0;
            while (j < 25) {
                IFile file = folder.getFile("file_" + j + ContentDescriptionPerformanceTest.getFileName(j));
                file.create(ResourceTestUtil.createInputStream(this.getContents(j)), false, ResourceTestUtil.createTestMonitor());
                ++j;
            }
            ++i;
        }
    }

    public void doTestContentDescription(String testDescription) throws Exception {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("bigproject");
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                project.accept(resource -> {
                    if (resource.getType() == 1 && !IGNORED_FILES.contains(resource.getName())) {
                        ContentDescriptionPerformanceTest.this.assertHasExpectedDescription(resource.getName(), ((IFile)resource).getContentDescription());
                    }
                    return true;
                });
            }
        }.run(this.getClass(), testDescription, 1, 1);
    }

    private String getContents(int number) {
        switch (number %= 3) {
            case 0: {
                return VALID_XML_CONTENTS;
            }
            case 1: {
                return VALID_XML_CONTENTS_WITH_NON_DEFAULT_ENCODING;
            }
        }
        return "whatever";
    }

    @Test
    public void test() throws Exception {
        this.test1SetUp();
        this.test2ColdContentDescription();
        this.test3WarmedUpContentDescription();
    }

    private void test1SetUp() throws CoreException {
        this.createFiles();
    }

    private void test2ColdContentDescription() throws Exception {
        this.doTestContentDescription("ColdContentDescription");
    }

    private void test3WarmedUpContentDescription() throws Exception {
        this.doTestContentDescription("WarmContentDescription");
    }
}

