/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HistoryStorePerformanceTest {
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    @Before
    public void setUp() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(10000);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
    }

    @After
    public void tearDown() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        project.clearHistory(ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testPerformance() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("file.txt");
        file.create(null, true, null);
        String contents = "fixed contents for performance test";
        int nTimes = 1000;
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < nTimes) {
            file.setContents(ResourceTestUtil.createInputStream(contents), true, true, null);
            ++i;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Adding " + nTimes + " states: " + (endTime - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        file.getHistory(null);
        endTime = System.currentTimeMillis();
        System.out.println("Retrieving " + nTimes + " states: " + (endTime - startTime) + " milliseconds.");
        startTime = System.currentTimeMillis();
        file.clearHistory(null);
        endTime = System.currentTimeMillis();
        System.out.println("Removing " + nTimes + " states: " + (endTime - startTime) + " milliseconds.");
    }
}

