/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.internal.localstore.HistoryStoreTest;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class LocalHistoryPerformanceTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    void cleanHistory() {
        ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore().clean(ResourceTestUtil.createTestMonitor());
    }

    void createTree(IFolder base, int filesPerFolder, int statesPerFile) throws CoreException {
        IFolder[] folders;
        folders = new IFolder[]{base.getFolder("folder1"), base.getFolder("folder2"), folders[0].getFolder("folder3"), folders[2].getFolder("folder4"), folders[3].getFolder("folder5")};
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(monitor -> {
            ResourceTestUtil.createInWorkspace((IResource[])folders);
            IFolder[] iFolderArray2 = folders;
            int n3 = folders.length;
            int n4 = 0;
            while (n4 < n3) {
                IFolder folder = iFolderArray2[n4];
                int j = 0;
                while (j < filesPerFolder) {
                    IFile file = folder.getFile("file" + j);
                    ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
                    int k = 0;
                    while (k < statesPerFile) {
                        file.setContents(ResourceTestUtil.createRandomContentsStream(), 2, ResourceTestUtil.createTestMonitor());
                        ++k;
                    }
                    ++j;
                }
                ++n4;
            }
        }, workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot()), 1, ResourceTestUtil.createTestMonitor());
    }

    IWorkspaceDescription setMaxFileStates(int maxFileStates) throws CoreException {
        IWorkspaceDescription currentDescription = ResourcesPlugin.getWorkspace().getDescription();
        IWorkspaceDescription testDescription = ResourcesPlugin.getWorkspace().getDescription();
        testDescription.setMaxFileStates(maxFileStates);
        ResourcesPlugin.getWorkspace().setDescription(testDescription);
        return currentDescription;
    }

    @After
    public void tearDown() throws Exception {
        HistoryStoreTest.wipeHistoryStore(ResourceTestUtil.createTestMonitor());
    }

    @Test
    public void testAddState() throws Exception {
        this.setMaxFileStates(100);
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1").getFile("file.txt");
        new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
            }

            protected void tearDown() throws CoreException {
                file.clearHistory(ResourceTestUtil.createTestMonitor());
                file.delete(1, ResourceTestUtil.createTestMonitor());
            }

            protected void test() throws CoreException {
                file.setContents(ResourceTestUtil.createRandomContentsStream(), 2, ResourceTestUtil.createTestMonitor());
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 30);
    }

    @Test
    public void testBug28603() throws Exception {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("myproject");
        final IFolder folder1 = project.getFolder("myfolder1");
        final IFolder folder2 = project.getFolder("myfolder2");
        final IFile file1 = folder1.getFile("myfile.txt");
        final IFile file2 = folder2.getFile(file1.getName());
        new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                ResourceTestUtil.createInWorkspace(new IResource[]{project, folder1, folder2});
                file1.create(ResourceTestUtil.createRandomContentsStream(), 1, ResourceTestUtil.createTestMonitor());
                file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
                file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
                file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
            }

            protected void tearDown() throws CoreException {
                ResourceTestUtil.removeFromWorkspace((IResource)ResourcesPlugin.getWorkspace().getRoot());
                IHistoryStore store = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
                store.remove(IPath.ROOT, ResourceTestUtil.createTestMonitor());
                store.removeGarbage();
            }

            protected void test() throws CoreException {
                file1.move(file2.getFullPath(), true, true, ResourceTestUtil.createTestMonitor());
                file2.move(file1.getFullPath(), true, true, ResourceTestUtil.createTestMonitor());
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 5);
    }

    private void testClearHistory(final int filesPerFolder, final int statesPerFile) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        final IFolder base = project.getFolder("base");
        ResourceTestUtil.removeFromWorkspace((IResource)base);
        new PerformanceTestRunner(){
            private IWorkspaceDescription original;

            protected void setUp() throws CoreException {
                this.original = LocalHistoryPerformanceTest.this.setMaxFileStates(1);
                LocalHistoryPerformanceTest.this.cleanHistory();
                LocalHistoryPerformanceTest.this.createTree(base, filesPerFolder, statesPerFile);
                ResourceTestUtil.removeFromWorkspace((IResource)base);
            }

            protected void tearDown() throws CoreException {
                if (this.original != null) {
                    ResourcesPlugin.getWorkspace().setDescription(this.original);
                }
            }

            protected void test() throws CoreException {
                base.clearHistory(ResourceTestUtil.createTestMonitor());
            }
        }.run(this.getClass(), this.testName.getMethodName(), 4, 3);
    }

    @Test
    public void testClearHistory100x4() throws Exception {
        this.testClearHistory(100, 4);
    }

    @Test
    public void testClearHistory20x20() throws Exception {
        this.testClearHistory(20, 20);
    }

    @Test
    public void testClearHistory4x100() throws Exception {
        this.testClearHistory(4, 100);
    }

    private void testCopyHistory(int filesPerFolder, int statesPerFile) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IFolder base = project.getFolder("base");
        this.createTree(base, filesPerFolder, statesPerFile);
        final IProject[] tmpProject = new IProject[]{project};
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                String newProjectName = ResourceTestUtil.createUniqueString();
                IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName);
                tmpProject[0].copy(newProject.getFullPath(), true, ResourceTestUtil.createTestMonitor());
                tmpProject[0] = newProject;
            }
        }.run(this.getClass(), this.testName.getMethodName(), 10, 1);
    }

    @Test
    public void testCopyHistory100x4() throws Exception {
        this.testCopyHistory(100, 4);
    }

    @Test
    public void testCopyHistory20x20() throws Exception {
        this.testCopyHistory(20, 20);
    }

    @Test
    public void testCopyHistory4x100() throws Exception {
        this.testCopyHistory(4, 100);
    }

    private void testGetDeletedMembers(int filesPerFolder, int statesPerFile) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IFolder base = project.getFolder("base");
        this.createTree(base, filesPerFolder, statesPerFile);
        ResourceTestUtil.removeFromWorkspace((IResource)base);
        final IProject tmpProject = project;
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                tmpProject.findDeletedMembersWithHistory(2, ResourceTestUtil.createTestMonitor());
            }
        }.run(this.getClass(), this.testName.getMethodName(), 2, 5);
    }

    @Test
    public void testGetDeletedMembers100x4() throws Exception {
        this.testGetDeletedMembers(100, 4);
    }

    @Test
    public void testGetDeletedMembers20x20() throws Exception {
        this.testGetDeletedMembers(20, 20);
    }

    @Test
    public void testGetDeletedMembers4x100() throws Exception {
        this.testGetDeletedMembers(4, 100);
    }

    @Test
    public void testGetHistory() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        final IFile file = project.getFile("file.txt");
        ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
        int i = 0;
        while (i < 100) {
            file.setContents(ResourceTestUtil.createRandomContentsStream(), 2, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                file.getHistory(ResourceTestUtil.createTestMonitor());
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 150);
    }

    private void testHistoryCleanUp(final int filesPerFolder, final int statesPerFile) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        final IFolder base = project.getFolder("base");
        ResourceTestUtil.removeFromWorkspace((IResource)base);
        new PerformanceTestRunner(){
            private IWorkspaceDescription original;

            protected void setUp() throws CoreException {
                this.original = LocalHistoryPerformanceTest.this.setMaxFileStates(1);
                LocalHistoryPerformanceTest.this.cleanHistory();
                LocalHistoryPerformanceTest.this.createTree(base, filesPerFolder, statesPerFile);
                ResourceTestUtil.removeFromWorkspace((IResource)base);
            }

            protected void tearDown() throws CoreException {
                if (this.original != null) {
                    ResourcesPlugin.getWorkspace().setDescription(this.original);
                }
            }

            protected void test() {
                LocalHistoryPerformanceTest.this.cleanHistory();
            }
        }.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    @Test
    public void testHistoryCleanUp100x4() throws Exception {
        this.testHistoryCleanUp(100, 4);
    }

    @Test
    public void testHistoryCleanUp20x20() throws Exception {
        this.testHistoryCleanUp(20, 20);
    }
}

