/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class MarkerPerformanceTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    IProject project;
    IFile file;
    IMarker[] markers;
    final int NUM_MARKERS = 5000;
    final int REPEAT = 100;

    @Test
    public void testSetAttributes1() throws Exception {
        final IWorkspaceRunnable runnable = monitor -> {
            int i = 0;
            while (i < 5000) {
                int j = 0;
                while (j < 100) {
                    this.markers[i].setAttribute("attrib", (Object)"hello");
                    ++j;
                }
                ++i;
            }
        };
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() throws CoreException {
                ResourcesPlugin.getWorkspace().run(runnable, null);
            }
        };
        runner.setFingerprintName("Set marker attributes");
        runner.run(this.getClass(), this.testName.getMethodName(), 1, 1);
    }

    @Test
    public void testSetAttributes2() throws Exception {
        final IWorkspaceRunnable runnable = monitor -> {
            int j = 0;
            while (j < 100) {
                int i = 0;
                while (i < 5000) {
                    this.markers[i].setAttribute("attrib", (Object)"hello");
                    ++i;
                }
                ++j;
            }
        };
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                ResourcesPlugin.getWorkspace().run(runnable, null);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 1, 1);
    }

    @Before
    public void setUp() throws Exception {
        IMarker[] createdMarkers = new IMarker[5000];
        IWorkspaceRunnable runnable = monitor -> {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestProject");
            this.project.create(null);
            this.project.open(null);
            this.file = this.project.getFile(IPath.ROOT.append("file.txt"));
            this.file.create(ResourceTestUtil.createRandomContentsStream(), true, null);
            int i = 0;
            while (i < 5000) {
                iMarkerArray[i] = this.file.createMarker("org.eclipse.core.resources.bookmark");
                ++i;
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        this.markers = createdMarkers;
    }
}

