/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class PropertyManagerPerformanceTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();

    public static String getPropertyValue(int size) {
        StringBuilder value = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            value.append((char)(Math.random() * 65535.0));
            ++i;
        }
        return value.toString();
    }

    private List<IResource> createTree(IFolder base, int filesPerFolder) throws CoreException {
        IFolder[] folders;
        folders = new IFolder[]{base.getFolder("folder1"), base.getFolder("folder2"), folders[0].getFolder("folder3"), folders[2].getFolder("folder4"), folders[3].getFolder("folder5")};
        ArrayList<IResource> resources = new ArrayList<IResource>(filesPerFolder * folders.length);
        resources.addAll(Arrays.asList(folders));
        ResourceTestUtil.createInWorkspace((IResource[])folders);
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder = iFolderArray[n2];
            int j = 0;
            while (j < filesPerFolder) {
                IFile file = folder.getFile("file" + j);
                ResourceTestUtil.createInWorkspace(file, ResourceTestUtil.createRandomString());
                resources.add((IResource)file);
                ++j;
            }
            ++n2;
        }
        return resources;
    }

    private void testGetProperty(int filesPerFolder, final int properties, int measurements, int repetitions) throws Exception {
        IProject proj1 = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        IFolder folder1 = proj1.getFolder("folder1");
        final List<IResource> allResources = this.createTree(folder1, filesPerFolder);
        for (IResource resource : allResources) {
            int j = 0;
            while (j < properties) {
                resource.setPersistentProperty(new QualifiedName("org.eclipse.core.tests.resources", "prop" + j), PropertyManagerPerformanceTest.getPropertyValue(200));
                ++j;
            }
        }
        new PerformanceTestRunner(){

            protected void test() throws CoreException {
                int j = 0;
                while (j < properties) {
                    for (IResource resource : allResources) {
                        Assert.assertNotNull((Object)resource.getPersistentProperty(new QualifiedName("org.eclipse.core.tests.resources", "prop" + j)));
                    }
                    ++j;
                }
            }
        }.run(this.getClass(), this.testName.getMethodName(), measurements, repetitions);
        ((Workspace)ResourcesPlugin.getWorkspace()).getPropertyManager().deleteProperties((IResource)folder1, 2);
    }

    @Test
    public void testGetProperty100x4() throws Exception {
        this.testGetProperty(100, 4, 10, 2);
    }

    @Test
    public void testGetProperty20x20() throws Exception {
        this.testGetProperty(20, 20, 10, 2);
    }

    @Test
    public void testGetProperty4x100() throws Exception {
        this.testGetProperty(4, 100, 10, 1);
    }

    private void testSetProperty(int filesPerFolder, int properties, int measurements, int repetitions) throws Exception {
        IProject proj1 = ResourcesPlugin.getWorkspace().getRoot().getProject("proj1");
        final IFolder folder1 = proj1.getFolder("folder1");
        final List<IResource> allResources = this.createTree(folder1, filesPerFolder);
        new PerformanceTestRunner(){

            protected void tearDown() throws CoreException {
                ((Workspace)ResourcesPlugin.getWorkspace()).getPropertyManager().deleteProperties((IResource)folder1, 2);
            }

            protected void test() throws CoreException {
                for (IResource resource : allResources) {
                    resource.setPersistentProperty(new QualifiedName("org.eclipse.core.tests.resources", "prop" + (int)Math.random() * 50), PropertyManagerPerformanceTest.getPropertyValue(200));
                }
            }
        }.run(this.getClass(), this.testName.getMethodName(), measurements, repetitions);
    }

    @Test
    public void testSetProperty100x4() throws Exception {
        this.testSetProperty(100, 4, 10, 1);
    }

    @Test
    public void testSetProperty20x20() throws Exception {
        this.testSetProperty(20, 20, 10, 4);
    }

    @Test
    public void testSetProperty4x100() throws Exception {
        this.testSetProperty(4, 100, 10, 20);
    }
}

