/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.WorkspaceTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class WorkspacePerformanceTest {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public WorkspaceTestRule workspaceRule = new WorkspaceTestRule();
    private static final String chars = "abcdefghijklmnopqrstuvwxyz";
    static final int REPEATS = 5;
    private static final int TREE_WIDTH = 10;
    private static final int DEFAULT_TOTAL_RESOURCES = 10000;
    private final Random random = new Random();
    IFolder testFolder;
    IProject testProject;

    IFolder copyFolder() throws CoreException {
        IFolder destination = this.testProject.getFolder("CopyDestination");
        this.testFolder.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        return destination;
    }

    void createAndPopulateProject(int totalResources) throws CoreException {
        ResourcesPlugin.getWorkspace().run(monitor -> {
            this.testProject.create(ResourceTestUtil.createTestMonitor());
            this.testProject.open(ResourceTestUtil.createTestMonitor());
            this.createFolder(this.testFolder, totalResources);
        }, ResourceTestUtil.createTestMonitor());
    }

    private byte[] createBytes(int length) {
        byte[] bytes = new byte[length];
        this.random.nextBytes(bytes);
        return bytes;
    }

    IFolder createFolder(IFolder topFolder, int totalResources) throws CoreException {
        topFolder.create(0, true, ResourceTestUtil.createTestMonitor());
        int depth = (int)(Math.log(totalResources) / Math.log(10.0));
        this.recursiveCreateChildren(topFolder, depth - 1);
        return topFolder;
    }

    private String createString(int length) {
        StringBuilder buf = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            buf.append(chars.charAt(this.random.nextInt(chars.length())));
            ++i;
        }
        return buf.toString();
    }

    void deleteAndRecreateProject() throws CoreException {
        this.testProject.delete(8, null);
        this.testProject.create(null);
        this.testProject.open(0, null);
    }

    IFolder moveFolder() throws CoreException {
        IFolder destination = this.testFolder.getProject().getFolder("MoveDestination");
        this.testFolder.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        return destination;
    }

    private void recursiveCreateChildren(IFolder parentFolder, int depth) throws CoreException {
        int i = 0;
        while (i < 10) {
            IFile file = parentFolder.getFile(this.createString(10));
            file.create((InputStream)new ByteArrayInputStream(this.createBytes(5000)), 0, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        if (depth <= 0) {
            return;
        }
        i = 0;
        while (i < 10) {
            IFolder folder = parentFolder.getFolder(this.createString(6));
            folder.create(0, true, ResourceTestUtil.createTestMonitor());
            this.recursiveCreateChildren(folder, depth - 1);
            ++i;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        this.testFolder = this.testProject.getFolder("TopFolder");
    }

    @Test
    public void testCreateResources() throws SecurityException, Exception {
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void setUp() {
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
            }
        };
        runner.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    @Test
    public void testDeleteProject() throws SecurityException, Exception {
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(0, null);
            }
        };
        runner.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    @Test
    public void testFolderCopy() throws SecurityException, Exception {
        new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.copyFolder();
            }
        }.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    @Test
    public void testFolderMove() throws SecurityException, Exception {
        new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(10000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.moveFolder();
            }
        }.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    @Test
    public void testRefreshProject() throws SecurityException, Exception {
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(50000);
                WorkspacePerformanceTest.this.deleteAndRecreateProject();
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.testProject.refreshLocal(2, null);
            }
        };
        runner.setFingerprintName("Refresh Project");
        runner.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    @Test
    public void testCloseOpenProject() throws SecurityException, Exception {
        new PerformanceTestRunner(){

            protected void setUp() throws CoreException {
                WorkspacePerformanceTest.this.createAndPopulateProject(50000);
                WorkspacePerformanceTest.this.waitForBackgroundActivity();
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.testProject.close(null);
                WorkspacePerformanceTest.this.testProject.open(null);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 5, 3);
    }

    @Test
    public void testLoadSnapshot() throws SecurityException, Exception {
        IProject snapProject = ResourcesPlugin.getWorkspace().getRoot().getProject("SnapProject");
        ResourceTestUtil.createInWorkspace((IResource)snapProject);
        final URI snapshotLocation = snapProject.getFile("snapshot.zip").getLocationURI();
        this.createAndPopulateProject(50000);
        this.waitForBackgroundActivity();
        try {
            this.testProject.saveSnapshot(1, snapshotLocation, null);
            this.testProject.delete(1, null);
        }
        catch (CoreException e) {
            Assert.fail((String)"Failed to create snapshot during testLoadSnapshot");
        }
        this.waitForBackgroundActivity();
        new PerformanceTestRunner(){

            protected void setUp() {
            }

            protected void tearDown() throws CoreException {
                WorkspacePerformanceTest.this.testProject.delete(1, null);
            }

            protected void test() throws CoreException {
                WorkspacePerformanceTest.this.testProject.create(null);
                WorkspacePerformanceTest.this.testProject.loadSnapshot(1, snapshotLocation, null);
                WorkspacePerformanceTest.this.testProject.open(null);
            }
        }.run(this.getClass(), this.testName.getMethodName(), 5, 1);
    }

    public void waitForBackgroundActivity() {
        this.waitForSnapshot();
        ResourceTestUtil.waitForRefresh();
        ResourceTestUtil.waitForBuild();
    }

    private void waitForSnapshot() {
        Job wait = new Job("Wait"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        wait.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        wait.schedule();
        try {
            wait.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

