/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.refresh;

import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.refresh.RefreshJob;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.TestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class RefreshJobTest {
    private static final String REFRESH_JOB_FIELD_NAME = "refreshJob";
    private boolean defaultRefresh;
    private boolean shouldResetDefault;
    int fastRefreshThreshold = 1000;
    int slowRefreshThreshold = 2000;
    int baseRefreshDepth = 1000;
    int depthIncreaseStep = 1000;
    int updateDelay = 200;
    int maxRecursionDeep = 0x40000000;
    private RefreshJob originalJob;

    @BeforeEach
    public void setUp() {
        IEclipsePreferences prefs = this.getPrefs();
        this.defaultRefresh = prefs.getBoolean("refresh.enabled", false);
        if (this.defaultRefresh) {
            prefs.putBoolean("refresh.enabled", false);
            this.shouldResetDefault = true;
        }
        TestUtil.waitForJobs("setup", 100L, 5000L);
        this.updateDelay = 0;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.restoreRefreshJob();
        if (this.shouldResetDefault) {
            this.getPrefs().putBoolean("refresh.enabled", this.defaultRefresh);
        }
    }

    private IEclipsePreferences getPrefs() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
    }

    @Test
    public void testBug578487_refreshLoop() throws Exception {
        String name = "testBug578487_refreshLoop";
        int minDepth = 0;
        int maxDepth = this.maxRecursionDeep;
        int filesCount = 0;
        int directoriesCount = 9;
        int createDepth = 2;
        this.depthIncreaseStep = 2;
        this.fastRefreshThreshold = 0x3FFFFFFF;
        this.slowRefreshThreshold = Integer.MAX_VALUE;
        this.baseRefreshDepth = 1000;
        this.runtest(name, minDepth, maxDepth, directoriesCount, filesCount, createDepth);
    }

    @Test
    public void testBasicRefresh() throws Exception {
        String name = "testBasicRefresh";
        int minDepth = 0;
        int maxDepth = 2;
        int directoriesCount = 3;
        int filesCount = 1;
        int createDepth = 2;
        this.runtest(name, minDepth, maxDepth, directoriesCount, filesCount, createDepth);
    }

    @Test
    public void testFastRefresh() throws Exception {
        String name = "testFastRefresh";
        int minDepth = 0;
        int maxDepth = 16;
        int directoriesCount = 3;
        int filesCount = 1;
        int createDepth = 2;
        this.depthIncreaseStep = 2;
        this.fastRefreshThreshold = 0x3FFFFFFF;
        this.slowRefreshThreshold = Integer.MAX_VALUE;
        this.baseRefreshDepth = 1000;
        this.runtest(name, minDepth, maxDepth, directoriesCount, filesCount, createDepth);
    }

    @Test
    @Disabled(value="test is disabled because it needs 400 seconds on fast SSD on Linux")
    public void testSmallRecursionRefresh() throws Exception {
        String name = "testSmallRecursionRefresh";
        this.maxRecursionDeep = 8;
        int minDepth = 0;
        int maxDepth = this.maxRecursionDeep;
        int directoriesCount = 6;
        int filesCount = 0;
        int createDepth = 600;
        this.depthIncreaseStep = 1;
        this.fastRefreshThreshold = 0x3FFFFFFF;
        this.slowRefreshThreshold = Integer.MAX_VALUE;
        this.baseRefreshDepth = 1000;
        this.runtest(name, minDepth, maxDepth, directoriesCount, filesCount, createDepth);
    }

    @Test
    @Disabled(value="test is disabled because it needs 250 seconds on fast SSD on Linux")
    public void testBigRecursionDeepRefresh() throws Exception {
        String name = "testBigRecursionDeepRefresh";
        this.maxRecursionDeep = 0x40000000;
        int minDepth = 0;
        int maxDepth = this.maxRecursionDeep;
        int directoriesCount = 6;
        int filesCount = 0;
        int createDepth = 600;
        this.depthIncreaseStep = 1;
        this.fastRefreshThreshold = 0x3FFFFFFF;
        this.slowRefreshThreshold = Integer.MAX_VALUE;
        this.baseRefreshDepth = 1000;
        this.runtest(name, minDepth, maxDepth, directoriesCount, filesCount, createDepth);
    }

    @Test
    public void testSlowRefresh() throws Exception {
        String name = "testSlowRefresh";
        int minDepth = 0;
        int maxDepth = 1;
        int directoriesCount = 3;
        int filesCount = 1;
        int createDepth = 2;
        this.depthIncreaseStep = 1;
        this.fastRefreshThreshold = Integer.MIN_VALUE;
        this.slowRefreshThreshold = Integer.MIN_VALUE;
        this.baseRefreshDepth = 1000;
        this.runtest(name, minDepth, maxDepth, directoriesCount, filesCount, createDepth);
    }

    @Test
    public void testProjectRule(TestInfo testInfo) throws Exception {
        TestRefreshJob refreshJob = this.createAndReplaceDefaultJob();
        IProject project = this.createProject(testInfo.getDisplayName());
        try {
            IFolder parent = project.getFolder("parent");
            parent.create(true, true, null);
            IFolder child = parent.getFolder("child");
            child.create(true, true, null);
            LinkedHashSet<Object> expected = new LinkedHashSet<Object>();
            expected.add(project.getFolder(".settings"));
            expected.add(parent);
            expected.add(child);
            expected.add(project);
            boolean releaseRule = true;
            try {
                Job.getJobManager().beginRule((ISchedulingRule)project, null);
                refreshJob.refresh((IResource)project);
                Thread.sleep(1000L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)refreshJob.refreshStarted, (String)"Refresh was not started");
                org.junit.jupiter.api.Assertions.assertFalse((boolean)refreshJob.refreshDone, (String)"Refresh should wait on rule");
                org.junit.jupiter.api.Assertions.assertEquals((Object)Collections.EMPTY_SET, refreshJob.visitedResources, (String)"Should not visit anything yet");
                Job.getJobManager().endRule((ISchedulingRule)project);
                releaseRule = false;
                TestUtil.waitForJobs(testInfo.getDisplayName(), 100L, 1000L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)refreshJob.refreshStarted, (String)"Refresh was not started");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)refreshJob.refreshDone, (String)"Refresh was not finished");
                org.junit.jupiter.api.Assertions.assertEquals(expected, refreshJob.visitedResources, (String)"Missing refresh");
            }
            finally {
                if (releaseRule) {
                    Job.getJobManager().endRule((ISchedulingRule)project);
                }
            }
        }
        finally {
            RefreshJobTest.deleteProject(testInfo.getDisplayName());
        }
    }

    @Test
    @Disabled(value="disabled for now, is unstable")
    public void testUnrelatedRule(TestInfo testInfo) throws Exception {
        TestRefreshJob refreshJob = this.createAndReplaceDefaultJob();
        IProject project = this.createProject(testInfo.getDisplayName());
        try {
            IFolder parent = project.getFolder("parent");
            parent.create(true, true, null);
            IFolder child = parent.getFolder("child");
            child.create(true, true, null);
            LinkedHashSet<IFolder> expected = new LinkedHashSet<IFolder>();
            IFolder rule = project.getFolder(".settings");
            expected.add(child);
            boolean releaseRule = true;
            try {
                Job.getJobManager().beginRule((ISchedulingRule)rule, null);
                refreshJob.refresh((IResource)child);
                TestUtil.waitForJobs(testInfo.getDisplayName(), 10L, 60000L, ResourcesPlugin.FAMILY_AUTO_REFRESH);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)refreshJob.refreshStarted, (String)"Refresh was not started");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)refreshJob.refreshDone, (String)"Refresh was not finished");
                Job.getJobManager().endRule((ISchedulingRule)rule);
                releaseRule = false;
                org.junit.jupiter.api.Assertions.assertEquals(expected, refreshJob.visitedResources, (String)"Missing refresh");
            }
            finally {
                if (releaseRule) {
                    Job.getJobManager().endRule((ISchedulingRule)rule);
                }
            }
        }
        finally {
            RefreshJobTest.deleteProject(testInfo.getDisplayName());
        }
    }

    private void runtest(String name, int minDepth, int maxDepth, int directoriesCount, int filesCount, int createDepth) throws Exception, CoreException {
        try {
            IProject project = this.createProject(name);
            IPath projectRoot = project.getLocation();
            project.close(null);
            AtomicInteger result = new AtomicInteger(0);
            this.createDirectoriesViaFileIo(projectRoot.toFile().toPath(), directoriesCount, filesCount, createDepth, result);
            org.junit.jupiter.api.Assertions.assertTrue((result.get() > 0 ? 1 : 0) != 0, (String)"Expect to generate some files");
            System.out.println("\nTest " + name + " generated " + String.valueOf(result) + " files");
            project.open(null);
            TestRefreshJob refreshJob = this.createAndReplaceDefaultJob();
            refreshJob.refresh((IResource)project);
            refreshJob.join();
            this.assertAllResourcesRefreshed(project, refreshJob);
            this.assertDepth(refreshJob, minDepth, maxDepth);
        }
        finally {
            RefreshJobTest.deleteProject(name);
        }
    }

    private void assertDepth(TestRefreshJob refreshJob, int minDepth, int maxDepth) {
        org.junit.jupiter.api.Assertions.assertEquals((int)minDepth, (int)refreshJob.minDepth, (String)"Unexpected min depth");
        org.junit.jupiter.api.Assertions.assertEquals((int)maxDepth, (int)refreshJob.maxDepth, (String)"Unexpected max depth");
    }

    private void assertAllResourcesRefreshed(IProject project, TestRefreshJob refreshJob) throws Exception {
        Set<IResource> resources = refreshJob.visitedResources;
        project.refreshLocal(2, null);
        LinkedHashSet missing = new LinkedHashSet();
        LinkedHashSet visited = new LinkedHashSet();
        project.accept(resource -> {
            if (resource.getType() == 1) {
                return true;
            }
            visited.add(resource);
            if (!resources.contains(resource)) {
                missing.add(resource);
            }
            return true;
        });
        ((AbstractCollectionAssert)Assertions.assertThat(missing).as("resources not refreshed", new Object[0])).isEmpty();
        ((AbstractCollectionAssert)Assertions.assertThat(visited).as("visited projects", new Object[0])).isNotEmpty();
        ((AbstractCollectionAssert)Assertions.assertThat(resources).as("refreshed resources", new Object[0])).isNotEmpty();
    }

    private TestRefreshJob createAndReplaceDefaultJob() throws Exception {
        TestRefreshJob job = new TestRefreshJob(this.fastRefreshThreshold, this.slowRefreshThreshold, this.baseRefreshDepth, this.depthIncreaseStep, this.updateDelay, this.maxRecursionDeep);
        RefreshManager refreshManager = ((Workspace)ResourcesPlugin.getWorkspace()).getRefreshManager();
        Field field = RefreshManager.class.getDeclaredField(REFRESH_JOB_FIELD_NAME);
        field.setAccessible(true);
        this.originalJob = (RefreshJob)field.get(refreshManager);
        field.set(refreshManager, (Object)job);
        return job;
    }

    private void restoreRefreshJob() throws Exception {
        RefreshManager refreshManager = ((Workspace)ResourcesPlugin.getWorkspace()).getRefreshManager();
        Field field = RefreshManager.class.getDeclaredField(REFRESH_JOB_FIELD_NAME);
        field.setAccessible(true);
        field.set(refreshManager, this.originalJob);
    }

    private void createDirectoriesViaFileIo(Path root, int directoriesCount, int filesCount, int createDepth, AtomicInteger result) throws Exception {
        if (createDepth <= 0) {
            return;
        }
        if (directoriesCount <= 0) {
            directoriesCount = 1;
        }
        ArrayList<Path> dirs = new ArrayList<Path>();
        int i = 0;
        while (i < directoriesCount) {
            Path dir = Files.createDirectory(root.resolve("dir_" + i), new FileAttribute[0]);
            result.incrementAndGet();
            dirs.add(dir);
            int j = 0;
            while (j < filesCount) {
                Files.createFile(dir.resolve("file_" + j), new FileAttribute[0]);
                result.incrementAndGet();
                ++j;
            }
            ++i;
        }
        --createDepth;
        --directoriesCount;
        --filesCount;
        for (Path dir : dirs) {
            this.createDirectoriesViaFileIo(dir, directoriesCount, filesCount, createDepth, result);
        }
    }

    private IProject createProject(String name) throws Exception {
        IWorkspaceRoot root = RefreshJobTest.getWorkspaceRoot();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)RefreshJobTest.deleteProject(name).isAccessible());
        IProject project = root.getProject(name);
        project.create(null);
        project.open(null);
        return project;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private static IProject deleteProject(String name) throws Exception {
        IProject pro = RefreshJobTest.getWorkspaceRoot().getProject(name);
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        return pro;
    }

    class TestRefreshJob
    extends RefreshJob {
        int maxDepth;
        int minDepth;
        Set<IResource> visitedResources;
        volatile boolean refreshStarted;
        volatile boolean refreshDone;

        protected TestRefreshJob(int fastRefreshThreshold, int slowRefreshThreshold, int baseRefreshDepth, int depthIncreaseStep, int updateDelay, int maxRecursionDeep) {
            super(fastRefreshThreshold, slowRefreshThreshold, baseRefreshDepth, depthIncreaseStep, updateDelay, maxRecursionDeep, (Workspace)ResourcesPlugin.getWorkspace());
            this.visitedResources = new LinkedHashSet<IResource>();
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            this.refreshStarted = true;
            IStatus status = super.runInWorkspace(monitor);
            this.refreshDone = true;
            return status;
        }

        protected List<IResource> collectChildrenToDepth(IResource resource, ArrayList<IResource> children, int depth) {
            List list = super.collectChildrenToDepth(resource, children, depth);
            this.visitedResources.add(resource);
            this.visitedResources.addAll(list);
            if (this.maxDepth < depth) {
                this.maxDepth = depth;
            }
            if (this.minDepth > depth) {
                this.minDepth = depth;
            }
            return list;
        }
    }
}

