/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.refresh;

import java.nio.file.Path;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestUtil;
import org.eclipse.core.tests.resources.refresh.TestRefreshProvider;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class RefreshProviderTest {
    private boolean originalRefreshSetting;

    @BeforeEach
    public void setUp() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        this.originalRefreshSetting = prefs.getBoolean("refresh.enabled", false);
        prefs.putBoolean("refresh.enabled", true);
        ResourceTestUtil.waitForRefresh();
        TestRefreshProvider.reset();
    }

    @AfterEach
    public void tearDown() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.enabled", this.originalRefreshSetting);
        ResourceTestUtil.waitForRefresh();
        TestRefreshProvider.reset();
    }

    @Test
    public void testLinkedFile(@TempDir Path tempDirectory) throws Exception {
        IPath location = IPath.fromPath((Path)tempDirectory).append("test");
        String name = "testUnmonitorLinkedResource";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        ResourceTestUtil.createInWorkspace((IResource)project);
        this.joinAutoRefreshJobs();
        IFile link = project.getFile("Link");
        TestRefreshProvider provider = TestRefreshProvider.getInstance();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).hasSize(1);
        link.createLink(location, 16, ResourceTestUtil.createTestMonitor());
        this.joinAutoRefreshJobs();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).hasSize(2);
        link.delete(1, ResourceTestUtil.createTestMonitor());
        this.joinAutoRefreshJobs();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).hasSize(1);
        ResourceTestUtil.removeFromWorkspace((IResource)project);
        this.joinAutoRefreshJobs();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).isEmpty();
        Object[] failures = provider.getFailures();
        Assertions.assertThat((Object[])failures).isEmpty();
    }

    @Test
    public void testProjectCloseOpen() throws Exception {
        String name = "testProjectCloseOpen";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        ResourceTestUtil.createInWorkspace((IResource)project);
        this.joinAutoRefreshJobs();
        TestRefreshProvider provider = TestRefreshProvider.getInstance();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).hasSize(1);
        project.close(ResourceTestUtil.createTestMonitor());
        this.joinAutoRefreshJobs();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).isEmpty();
        project.open(ResourceTestUtil.createTestMonitor());
        this.joinAutoRefreshJobs();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).hasSize(1);
        ResourceTestUtil.removeFromWorkspace((IResource)project);
        this.joinAutoRefreshJobs();
        Assertions.assertThat((Object[])provider.getMonitoredResources()).isEmpty();
        Object[] failures = provider.getFailures();
        Assertions.assertThat((Object[])failures).isEmpty();
    }

    @Test
    public void testProjectCreateDelete(TestInfo testInfo) throws Exception {
        String name = "testProjectCreateDelete";
        int maxRuns = 1000;
        int i = 0;
        HashMap<Integer, CoreException> fails = new HashMap<Integer, CoreException>();
        while (i < 1000) {
            if (i % 50 == 0) {
                TestUtil.waitForJobs(testInfo.getDisplayName(), 5L, 100L);
            }
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)this.createProject(name).isAccessible());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)RefreshProviderTest.deleteProject(name).exists());
            }
            catch (CoreException e) {
                fails.put(i, e);
            }
            ++i;
        }
        Assertions.assertThat(fails).isEmpty();
    }

    private IProject createProject(String name) throws Exception {
        IWorkspaceRoot root;
        IProject project;
        IProject pro = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        if (!(project = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(name)).exists()) {
            project.create(null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        return project;
    }

    private static IProject deleteProject(String name) throws Exception {
        IProject pro = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        return pro;
    }

    private void joinAutoRefreshJobs() throws InterruptedException {
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
    }
}

