/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.refresh;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.resources.refresh.RefreshProvider;

public class TestRefreshProvider
extends RefreshProvider
implements IRefreshMonitor {
    private final List<AssertionFailedError> failures = new CopyOnWriteArrayList<AssertionFailedError>();
    private final Set<Object> monitoredResources = Collections.synchronizedSet(new HashSet());
    private static volatile TestRefreshProvider instance;

    public static TestRefreshProvider getInstance() {
        return instance;
    }

    public TestRefreshProvider() {
        instance = this;
    }

    public static void reset() {
        if (instance != null) {
            TestRefreshProvider.instance.failures.clear();
            TestRefreshProvider.instance.monitoredResources.clear();
        }
    }

    public AssertionFailedError[] getFailures() {
        return this.failures.toArray(new AssertionFailedError[this.failures.size()]);
    }

    public IResource[] getMonitoredResources() {
        return this.monitoredResources.toArray(new IResource[this.monitoredResources.size()]);
    }

    public IRefreshMonitor installMonitor(IResource resource, IRefreshResult result) {
        if (!this.monitoredResources.add(resource)) {
            this.failures.add(new AssertionFailedError("installMonitor on resource that is already monitored: " + String.valueOf(resource)));
        }
        return this;
    }

    public void unmonitor(IResource resource) {
        if (resource == null) {
            this.monitoredResources.clear();
            return;
        }
        if (!this.monitoredResources.remove(resource)) {
            this.failures.add(new AssertionFailedError("Unmonitor on resource that is not monitored: " + String.valueOf(resource)));
        }
    }
}

