/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_025457 {
    @Test
    public void testFile() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("file.txt");
        IFile destFile = source.getFile("File.txt");
        ResourceTestUtil.createInWorkspace((IResource)source);
        String content = ResourceTestUtil.createRandomString();
        ResourceTestUtil.createInWorkspace(sourceFile, content);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = sourceFile.getContents();){
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sourceFile.move(destFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertThat((Object)source).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
        org.junit.jupiter.api.Assertions.assertEquals((Object)content, (Object)sourceFile.readString());
        Assertions.assertThat((Object)destFile).matches(Predicate.not(IResource::exists), "not exists");
    }

    @Test
    public void testFolder() throws IOException, CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (Platform.OS.isWindows() && ResourceTestUtil.isReadOnlySupported() ? 1 : 0) != 0);
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("SourceProject");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("Important.txt");
        IFolder destFolder = source.getFolder("Folder");
        IFile destFile = destFolder.getFile("Important.txt");
        ResourceTestUtil.createInWorkspace((IResource)source);
        ResourceTestUtil.createInWorkspace((IResource)sourceFolder);
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream stream = sourceFile.getContents();){
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sourceFolder.move(destFolder.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)source).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)sourceFolder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destFolder).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)destFile).matches(Predicate.not(IResource::exists), "not exists");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testProject() throws IOException, CoreException {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("Project");
        IFile sourceFile = source.getFile("Important.txt");
        IFile destFile = destination.getFile("Important.txt");
        ResourceTestUtil.createInWorkspace((IResource)source);
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = sourceFile.getContents();){
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> source.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)source).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)sourceFile).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)destination).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destFile).matches(IResource::exists, "exists");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

