/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.InputStream;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_026294 {
    private static final Predicate<IResource> isSynchronizedDepthInfinite = resource -> resource.isSynchronized(2);
    private static final Predicate<IResource> isSynchronizedDepthZero = resource -> resource.isSynchronized(0);

    @Test
    public void testDeleteOpenProjectWindows() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("a_folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = project.getFile("file2.txt");
        IFile file3 = folder.getFile("file3.txt");
        IFile projectFile = project.getFile(IPath.fromOSString((String)".project"));
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, file3});
        IPath projectRoot = project.getLocation();
        ResourceTestUtil.assertExistsInFileSystem((IResource)file1);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file2);
        ResourceTestUtil.assertExistsInFileSystem((IResource)file3);
        ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)projectFile);
        Throwable throwable = null;
        Object var10_11 = null;
        try (InputStream input = file1.getContents();){
            Assertions.assertThat((Object)projectFile).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)projectFile).matches(isSynchronizedDepthInfinite, "is synchronized");
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> project.delete(1, ResourceTestUtil.createTestMonitor()));
            ResourceTestUtil.assertExistsInWorkspace((IResource)project);
            ResourceTestUtil.assertExistsInFileSystem((IResource)project);
            ResourceTestUtil.assertExistsInWorkspace((IResource)file1);
            ResourceTestUtil.assertExistsInFileSystem((IResource)file1);
            Assertions.assertThat((Object)file1).matches(isSynchronizedDepthInfinite, "is synchronized");
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file2);
            ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file2);
            Assertions.assertThat((Object)file2).matches(isSynchronizedDepthInfinite, "is synchronized");
            ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file3);
            ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file3);
            Assertions.assertThat((Object)file3).matches(isSynchronizedDepthInfinite, "is synchronized");
            ResourceTestUtil.assertExistsInWorkspace((IResource)folder);
            ResourceTestUtil.assertExistsInFileSystem((IResource)folder);
            Assertions.assertThat((Object)folder).matches(isSynchronizedDepthInfinite, "is synchronized");
            ResourceTestUtil.assertExistsInWorkspace((IResource)projectFile);
            ResourceTestUtil.assertExistsInFileSystem((IResource)projectFile);
            Assertions.assertThat((Object)projectFile).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)project).matches(isSynchronizedDepthZero, "is synchronized");
            Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        project.delete(1, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)file1).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)file1).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)projectRoot).matches(it -> !it.toFile().exists(), "not exists");
    }

    @Test
    public void testDeleteOpenProjectLinux() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Linux", (Platform.OS.isLinux() && ResourceTestUtil.isReadOnlySupported() ? 1 : 0) != 0);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("a_folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = project.getFile("file2.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
        IPath projectRoot = project.getLocation();
        try {
            ResourceTestUtil.setReadOnly((IResource)folder, true);
            IFile projectFile = project.getFile(".project");
            Assertions.assertThat((Object)projectFile).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)projectFile).matches(isSynchronizedDepthInfinite, "is synchronized");
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> project.delete(1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)project).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file2).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)projectFile).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        }
        finally {
            if (folder.exists()) {
                ResourceTestUtil.setReadOnly((IResource)folder, false);
            }
        }
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        project.delete(1, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)file1).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)file1).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)projectRoot).matches(it -> !it.toFile().exists(), "not exists");
    }

    @Test
    public void testDeleteClosedProjectWindows() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("a_folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = project.getFile("file2.txt");
        IFile file3 = folder.getFile("file3.txt");
        IFile projectFile = project.getFile(IPath.fromOSString((String)".project"));
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, file3});
        IPath projectRoot = project.getLocation();
        Throwable throwable = null;
        Object var10_11 = null;
        try (InputStream input = file1.getContents();){
            project.close(ResourceTestUtil.createTestMonitor());
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> project.delete(5, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)project).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
            ResourceTestUtil.assertExistsInFileSystem((IResource)projectFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        project.delete(5, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)projectRoot).matches(it -> !it.toFile().exists(), "not exists");
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)projectFile);
    }

    @Test
    public void testDeleteClosedProjectLinux() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("a_folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = project.getFile("file2.txt");
        IFile projectFile = project.getFile(IPath.fromOSString((String)".project"));
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
        IPath projectRoot = project.getLocation();
        try {
            ResourceTestUtil.setReadOnly((IResource)folder, true);
            project.close(ResourceTestUtil.createTestMonitor());
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> project.delete(5, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)project).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
            ResourceTestUtil.assertExistsInFileSystem((IResource)projectFile);
            project.open(ResourceTestUtil.createTestMonitor());
        }
        finally {
            if (folder.exists()) {
                ResourceTestUtil.setReadOnly((IResource)folder, false);
            }
        }
        project.delete(5, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)project).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)projectRoot).matches(it -> !it.toFile().exists(), "not exists");
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)projectFile);
    }

    @Test
    public void testDeleteFolderWindows() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("a_folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file3 = folder.getFile("file3.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file3});
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream input = file1.getContents();){
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.delete(1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file3).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)folder).matches(isSynchronizedDepthInfinite, "is synchronized");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        folder.delete(1, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)file1).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)file1).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)folder).matches(isSynchronizedDepthInfinite, "is synchronized");
    }

    @Test
    public void testDeleteFolderLinux() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder folder = project.getFolder("a_folder");
        IFolder subFolder = folder.getFolder("sub-folder");
        IFile file1 = subFolder.getFile("file1.txt");
        IFile file3 = folder.getFile("file3.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file3});
        try {
            ResourceTestUtil.setReadOnly((IResource)subFolder, true);
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.delete(1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)subFolder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file3).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)folder).matches(isSynchronizedDepthInfinite, "is synchronized");
        }
        finally {
            if (subFolder.exists()) {
                ResourceTestUtil.setReadOnly((IResource)subFolder, false);
            }
        }
        Assertions.assertThat((Object)project).matches(isSynchronizedDepthInfinite, "is synchronized");
        folder.delete(1, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)file1).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)subFolder).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)file1).matches(isSynchronizedDepthInfinite, "is synchronized");
        Assertions.assertThat((Object)folder).matches(isSynchronizedDepthInfinite, "is synchronized");
    }
}

