/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_027271 {
    static final String VARIABLE_PREFIX = "pathvariable.";

    @BeforeEach
    public void setUp() {
        this.clearPathVariablesProperties();
    }

    @AfterEach
    public void tearDown() {
        this.clearPathVariablesProperties();
    }

    private void clearPathVariablesProperties() {
        String[] propertyNames;
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        String[] stringArray = propertyNames = preferences.propertyNames();
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (propertyName.startsWith(VARIABLE_PREFIX)) {
                preferences.setToDefault(propertyName);
            }
            ++n2;
        }
    }

    @Test
    public void testBug() {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IPathVariableManager pvm = ResourcesPlugin.getWorkspace().getPathVariableManager();
        Preferences prefs = ResourcesPlugin.getPlugin().getPluginPreferences();
        Assertions.assertThat((Object[])pvm.getPathVariableNames()).isEmpty();
        prefs.setValue("pathvariable.VALID_VAR", IPath.fromOSString((String)"c:/temp").toPortableString());
        Assertions.assertThat((Object[])pvm.getPathVariableNames()).containsExactly((Object[])new String[]{"VALID_VAR"});
        IPath relativePath = IPath.fromOSString((String)"temp");
        prefs.setValue("pathvariable.INVALID_VAR", relativePath.toPortableString());
        Assertions.assertThat((Object[])pvm.getPathVariableNames()).containsExactly((Object[])new String[]{"VALID_VAR"});
        IPath invalidPath = IPath.fromOSString((String)"c:\\a\\:\\b");
        prefs.setValue("pathvariable.ANOTHER_INVALID_VAR", invalidPath.toPortableString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)IPath.EMPTY.isValidPath(invalidPath.toPortableString()));
        Assertions.assertThat((Object[])pvm.getPathVariableNames()).containsExactly((Object[])new String[]{"VALID_VAR"});
    }
}

