/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.ResourceVisitorVerifier;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_028981 {
    @Test
    public void testBug() throws CoreException {
        QualifiedName partner = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISynchronizer synchronizer = workspace.getSynchronizer();
        synchronizer.add(partner);
        IProject project = workspace.getRoot().getProject("MyProject");
        IFile teamPrivateFile = project.getFile("teamPrivate.txt");
        IFile phantomFile = project.getFile("phantom.txt");
        IFile regularFile = project.getFile("regular.txt");
        IFile projectDescriptionFile = project.getFile(".project");
        IFolder settings = project.getFolder(".settings");
        IFile prefs = settings.getFile("org.eclipse.core.resources.prefs");
        ResourceTestUtil.createInWorkspace(new IResource[]{teamPrivateFile, regularFile});
        synchronizer.setSyncInfo(partner, (IResource)phantomFile, ResourceTestUtil.createRandomString().getBytes());
        teamPrivateFile.setTeamPrivateMember(true);
        Assertions.assertThat((Object)regularFile).matches(Predicate.not(IResource::isPhantom), "is not phantom");
        Assertions.assertThat((Object)regularFile).matches(Predicate.not(IResource::isTeamPrivateMember), "is not team-private member");
        Assertions.assertThat((Object)teamPrivateFile).matches(IResource::isTeamPrivateMember, "is team-private member");
        Assertions.assertThat((Object)teamPrivateFile).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)phantomFile).matches(IResource::isPhantom, "is phantom");
        Assertions.assertThat((Object)phantomFile).matches(Predicate.not(IResource::exists), "not exists");
        ResourceVisitorVerifier verifier = new ResourceVisitorVerifier();
        verifier.addExpected((IResource)project);
        verifier.addExpected((IResource)projectDescriptionFile);
        verifier.addExpected((IResource)regularFile);
        verifier.addExpected((IResource)settings);
        verifier.addExpected((IResource)prefs);
        project.accept((IResourceVisitor)verifier);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.isValid(), (String)verifier.getMessage());
        verifier.reset();
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> phantomFile.accept((IResourceVisitor)verifier));
        verifier.reset();
        verifier.addExpected((IResource)phantomFile);
        phantomFile.accept((IResourceVisitor)verifier, 2, 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.isValid(), (String)verifier.getMessage());
        verifier.reset();
        teamPrivateFile.accept((IResourceVisitor)verifier);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.isValid(), (String)verifier.getMessage());
        verifier.reset();
        verifier.addExpected((IResource)teamPrivateFile);
        teamPrivateFile.accept((IResourceVisitor)verifier, 2, 2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)verifier.isValid(), (String)verifier.getMessage());
    }
}

