/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_029671 {
    @Test
    public void testBug() throws CoreException {
        QualifiedName partner = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISynchronizer synchronizer = workspace.getSynchronizer();
        synchronizer.add(partner);
        IProject project = workspace.getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("source");
        IFile file = folder.getFile("file.txt");
        ResourceTestUtil.createInWorkspace((IResource)file);
        try {
            synchronizer.setSyncInfo(partner, (IResource)folder, ResourceTestUtil.createRandomString().getBytes());
            synchronizer.setSyncInfo(partner, (IResource)file, ResourceTestUtil.createRandomString().getBytes());
            IFolder targetFolder = project.getFolder("target");
            IFile targetFile = targetFolder.getFile(file.getName());
            folder.move(targetFolder.getFullPath(), false, false, ResourceTestUtil.createTestMonitor());
            Assertions.assertThat((Object)folder).matches(IResource::isPhantom, "is phantom");
            Assertions.assertThat((Object)file).matches(IResource::isPhantom, "is phantom");
            ResourceTestUtil.assertExistsInWorkspace((IResource)targetFolder);
            Assertions.assertThat((Object)targetFolder).matches(Predicate.not(IResource::isPhantom), "is not phantom");
            ResourceTestUtil.assertExistsInWorkspace((IResource)targetFile);
            Assertions.assertThat((Object)targetFile).matches(Predicate.not(IResource::isPhantom), "is not phantom");
        }
        finally {
            synchronizer.remove(partner);
        }
    }
}

