/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_029851 {
    private Collection<String> createChildren(int breadth, int depth, IPath prefix) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < breadth) {
            IPath child = prefix.append(Integer.toString(i)).addTrailingSeparator();
            result.add(child.toString());
            if (depth > 0) {
                result.addAll(this.createChildren(breadth, depth - 1, child));
            }
            ++i;
        }
        return result;
    }

    private void createResourceHierarchy() throws CoreException {
        int depth = 3;
        int breadth = 3;
        IPath prefix = IPath.fromOSString((String)"/a/");
        Collection<String> result = this.createChildren(breadth, depth, prefix);
        result.add(prefix.toString());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), result.toArray(new String[0]));
        ResourceTestUtil.createInWorkspace(resources);
    }

    @Test
    public void test() throws CoreException {
        this.createResourceHierarchy();
        QualifiedName key = new QualifiedName("local", ResourceTestUtil.createUniqueString());
        String value = ResourceTestUtil.createUniqueString();
        IResourceVisitor visitor = resource -> {
            resource.setPersistentProperty(key, value);
            return true;
        };
        ResourcesPlugin.getWorkspace().getRoot().accept(visitor);
    }
}

