/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_032076 {
    private static final Predicate<IResource> isSynchronizedDepthInfinite = resource -> resource.isSynchronized(2);
    private static final Predicate<IResource> isSynchronizedDepthZero = resource -> resource.isSynchronized(0);

    @Test
    public void testFileBugOnWindows() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder sourceParent = project.getFolder("source_parent");
        IFolder destinationParent = project.getFolder("destination_parent");
        IFile sourceFile = sourceParent.getFile("file1.txt");
        IFile destinationFile = destinationParent.getFile(sourceFile.getName());
        ResourceTestUtil.createInWorkspace(new IResource[]{sourceFile, destinationParent});
        String attributeKey = ResourceTestUtil.createRandomString();
        String attributeValue = ResourceTestUtil.createRandomString();
        long markerId = -1L;
        IMarker bookmark = sourceFile.createMarker("org.eclipse.core.resources.bookmark");
        bookmark.setAttribute(attributeKey, (Object)attributeValue);
        markerId = bookmark.getId();
        Throwable throwable = null;
        Object var13_13 = null;
        try (InputStream input = sourceFile.getContents();){
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sourceFile.move(destinationFile.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)sourceParent).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)destinationParent).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)destinationFile).matches(IResource::exists, "exists");
            IMarker marker = destinationFile.findMarker(markerId);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)marker);
            org.junit.jupiter.api.Assertions.assertEquals((Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)sourceFile).matches(isSynchronizedDepthZero, "is synchronized");
            sourceParent.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFolderBugOnWindows() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder sourceParent = project.getFolder("source_parent");
        IFolder destinationParent = project.getFolder("destination_parent");
        IFolder folder = sourceParent.getFolder("folder");
        IFolder destinationFolder = destinationParent.getFolder(folder.getName());
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, destinationParent});
        String attributeKey = ResourceTestUtil.createRandomString();
        String attributeValue = ResourceTestUtil.createRandomString();
        long markerId = -1L;
        IMarker bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
        bookmark.setAttribute(attributeKey, (Object)attributeValue);
        markerId = bookmark.getId();
        Throwable throwable = null;
        Object var15_15 = null;
        try (InputStream input = file1.getContents();){
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> folder.move(destinationFolder.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)sourceParent).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)destinationParent).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)destinationFolder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destinationFolder.getFile(file1.getName())).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destinationFolder.getFile(file2.getName())).matches(IResource::exists, "exists");
            IMarker marker = destinationFolder.getFile(file1.getName()).findMarker(markerId);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)marker);
            org.junit.jupiter.api.Assertions.assertEquals((Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file2).matches(Predicate.not(IResource::exists), "not exists");
            sourceParent.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file2).matches(Predicate.not(IResource::exists), "not exists");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testProjectBugOnWindows() throws Exception {
        Assume.assumeTrue((String)"only relevant on Windows", (boolean)Platform.OS.isWindows());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject sourceProject = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString() + ".source");
        IProject destinationProject = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString() + ".dest");
        IFile file1 = sourceProject.getFile("file1.txt");
        IFile file2 = sourceProject.getFile("file2.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2});
        File originalSourceProjectLocation = sourceProject.getLocation().toFile();
        String attributeKey = ResourceTestUtil.createRandomString();
        String attributeValue = ResourceTestUtil.createRandomString();
        long markerId = -1L;
        IMarker bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
        bookmark.setAttribute(attributeKey, (Object)attributeValue);
        markerId = bookmark.getId();
        try {
            Throwable throwable = null;
            Object var13_13 = null;
            try (InputStream input = file1.getContents();){
                org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sourceProject.move(destinationProject.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
                Assertions.assertThat((Object)sourceProject).matches(Predicate.not(IResource::exists), "not exists");
                Assertions.assertThat((Object)sourceProject).matches(isSynchronizedDepthInfinite, "is synchronized");
                Assertions.assertThat((Object)destinationProject).matches(IResource::exists, "exists");
                Assertions.assertThat((Object)destinationProject).matches(isSynchronizedDepthInfinite, "is synchronized");
                Assertions.assertThat((Object)destinationProject.getFile(file1.getProjectRelativePath())).matches(IResource::exists, "exists");
                Assertions.assertThat((Object)destinationProject.getFile(file2.getProjectRelativePath())).matches(IResource::exists, "exists");
                IMarker marker = destinationProject.getFile(file1.getProjectRelativePath()).findMarker(markerId);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)marker);
                org.junit.jupiter.api.Assertions.assertEquals((Object)attributeValue, (Object)marker.getAttribute(attributeKey));
                Assertions.assertThat((Object)workspace.getRoot()).matches(isSynchronizedDepthInfinite, "is synchronized");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            ResourceTestUtil.removeFromFileSystem(originalSourceProjectLocation);
        }
    }

    @Test
    @Disabled(value="test is currently failing and needs further investigation (bug 203078)")
    public void testFileBugOnLinux() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Linux", (Platform.OS.isLinux() && ResourceTestUtil.isReadOnlySupported() ? 1 : 0) != 0);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder sourceParent = project.getFolder("source_parent");
        IFolder roFolder = sourceParent.getFolder("sub-folder");
        IFolder destinationParent = project.getFolder("destination_parent");
        IFile sourceFile = roFolder.getFile("file.txt");
        IFile destinationFile = destinationParent.getFile("file.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{sourceFile, destinationParent});
        IFileStore roFolderStore = ((Resource)roFolder).getStore();
        String attributeKey = ResourceTestUtil.createRandomString();
        String attributeValue = ResourceTestUtil.createRandomString();
        long markerId = -1L;
        IMarker bookmark = sourceFile.createMarker("org.eclipse.core.resources.bookmark");
        bookmark.setAttribute(attributeKey, (Object)attributeValue);
        markerId = bookmark.getId();
        try {
            ResourceTestUtil.setReadOnly((IResource)roFolder, true);
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sourceFile.move(destinationFile.getFullPath(), 1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)sourceParent).matches(Predicate.not(isSynchronizedDepthInfinite), "is not synchronized");
            Assertions.assertThat((Object)destinationParent).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)destinationFile).matches(IResource::exists, "exists");
            IMarker marker = destinationFile.findMarker(markerId);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)marker);
            org.junit.jupiter.api.Assertions.assertEquals((Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            Assertions.assertThat((Object)sourceFile).matches(Predicate.not(IResource::exists), "not exists");
            sourceParent.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
        }
        finally {
            ResourceTestUtil.setReadOnly(roFolderStore, false);
        }
    }

    @Test
    @Disabled(value="test is currently failing and needs further investigation (bug 203078)")
    public void testFolderBugOnLinux() throws CoreException {
        Assume.assumeTrue((String)"only relevant on Linux", (Platform.OS.isLinux() && ResourceTestUtil.isReadOnlySupported() ? 1 : 0) != 0);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder sourceParent = project.getFolder("source_parent");
        IFolder roFolder = sourceParent.getFolder("sub-folder");
        IFolder folder = roFolder.getFolder("folder");
        IFile file1 = roFolder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IFolder destinationParent = project.getFolder("destination_parent");
        IFolder destinationROFolder = destinationParent.getFolder(roFolder.getName());
        ResourceTestUtil.createInWorkspace(new IResource[]{file1, file2, destinationParent});
        IFileStore roFolderLocation = ((Resource)roFolder).getStore();
        IFileStore destinationROFolderLocation = ((Resource)destinationROFolder).getStore();
        String attributeKey = ResourceTestUtil.createRandomString();
        String attributeValue = ResourceTestUtil.createRandomString();
        long markerId = -1L;
        IMarker bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
        bookmark.setAttribute(attributeKey, (Object)attributeValue);
        markerId = bookmark.getId();
        try {
            ResourceTestUtil.setReadOnly((IResource)roFolder, true);
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> roFolder.move(destinationParent.getFullPath().append(roFolder.getName()), 1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)sourceParent).matches(Predicate.not(isSynchronizedDepthInfinite), "is not synchronized");
            Assertions.assertThat((Object)destinationParent).matches(isSynchronizedDepthInfinite, "is synchronized");
            IFolder destinationFolder = destinationROFolder.getFolder(folder.getName());
            IFile destinationFile1 = destinationROFolder.getFile(file1.getName());
            IFile destinationFile2 = destinationFolder.getFile(file2.getName());
            Assertions.assertThat((Object)destinationROFolder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destinationFolder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destinationFile1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destinationFile2).matches(IResource::exists, "exists");
            IMarker marker = destinationROFolder.getFile(file1.getName()).findMarker(markerId);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)marker);
            org.junit.jupiter.api.Assertions.assertEquals((Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            Assertions.assertThat((Object)roFolder).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)folder).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)file1).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)file2).matches(Predicate.not(IResource::exists), "not exists");
            sourceParent.refreshLocal(2, ResourceTestUtil.createTestMonitor());
            Assertions.assertThat((Object)roFolder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)folder).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file1).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)file2).matches(Predicate.not(IResource::exists), "not exists");
        }
        finally {
            ResourceTestUtil.setReadOnly(roFolderLocation, false);
            ResourceTestUtil.setReadOnly(destinationROFolderLocation, false);
        }
    }

    @Test
    @Disabled(value="test is currently failing and needs further investigation (bug 203078)")
    public void testProjectBugOnLinux(@TempDir Path tempDirectory) throws CoreException, IOException {
        Assume.assumeTrue((String)"only relevant on Linux", (Platform.OS.isLinux() && ResourceTestUtil.isReadOnlySupported() ? 1 : 0) != 0);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject sourceProject = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString() + ".source");
        IFileStore projectParentStore = ResourceTestUtil.getFileStore(tempDirectory);
        IFileStore projectStore = projectParentStore.getChild(sourceProject.getName());
        IProjectDescription sourceDescription = workspace.newProjectDescription(sourceProject.getName());
        sourceDescription.setLocationURI(projectStore.toURI());
        IProject destinationProject = workspace.getRoot().getProject(ResourceTestUtil.createUniqueString() + ".dest");
        IProjectDescription destinationDescription = workspace.newProjectDescription(destinationProject.getName());
        sourceProject.create(sourceDescription, ResourceTestUtil.createTestMonitor());
        sourceProject.open(ResourceTestUtil.createTestMonitor());
        IFile file1 = sourceProject.getFile("file1.txt");
        ResourceTestUtil.createInWorkspace(new IResource[]{file1});
        File originalSourceProjectLocation = sourceProject.getLocation().toFile();
        String attributeKey = ResourceTestUtil.createRandomString();
        String attributeValue = ResourceTestUtil.createRandomString();
        long markerId = -1L;
        IMarker bookmark = file1.createMarker("org.eclipse.core.resources.bookmark");
        bookmark.setAttribute(attributeKey, (Object)attributeValue);
        markerId = bookmark.getId();
        try {
            ResourceTestUtil.setReadOnly(projectParentStore, true);
            org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> sourceProject.move(destinationDescription, 1, ResourceTestUtil.createTestMonitor()));
            Assertions.assertThat((Object)sourceProject).matches(Predicate.not(IResource::exists), "not exists");
            Assertions.assertThat((Object)destinationProject).matches(IResource::exists, "exists");
            Assertions.assertThat((Object)destinationProject).matches(isSynchronizedDepthInfinite, "is synchronized");
            Assertions.assertThat((Object)destinationProject.getFile(file1.getProjectRelativePath())).matches(IResource::exists, "exists");
            IMarker marker = destinationProject.getFile(file1.getProjectRelativePath()).findMarker(markerId);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)marker);
            org.junit.jupiter.api.Assertions.assertEquals((Object)attributeValue, (Object)marker.getAttribute(attributeKey));
            Assertions.assertThat((Object)projectStore).matches(it -> it.fetchInfo().exists(), "exists");
            Assertions.assertThat((Object)workspace.getRoot()).matches(isSynchronizedDepthInfinite, "is synchronized");
        }
        finally {
            ResourceTestUtil.setReadOnly(projectParentStore, false);
            ResourceTestUtil.removeFromFileSystem(originalSourceProjectLocation);
        }
    }
}

