/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_044106 {
    private static final Predicate<IFileStore> exists = store -> store.fetchInfo().exists();
    @TempDir
    private Path tempDirectory;

    private void createSymLink(String target, String local) throws InterruptedException, IOException {
        Process p = Runtime.getRuntime().exec(new String[]{"/bin/ln", "-s", target, local});
        p.waitFor();
    }

    private void doTestDeleteLinkedFile(int deleteFlags) throws Exception {
        IFileStore linkDestFile = ResourceTestUtil.getFileStore(this.tempDirectory).getChild(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInFileSystem(linkDestFile);
        Assertions.assertThat((Object)linkDestFile).matches(exists, "exists");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)project);
        String target = new File(linkDestFile.toURI()).getAbsolutePath();
        IFile linkedFile = project.getFile("linkedFile");
        String local = linkedFile.getLocation().toOSString();
        this.createSymLink(target, local);
        ResourceTestUtil.assertExistsInFileSystem((IResource)linkedFile);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)linkedFile);
        linkedFile.delete(deleteFlags, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)linkedFile);
        Assertions.assertThat((Object)linkDestFile).matches(exists, "exists");
    }

    private void doTestDeleteLinkedFolder(IFolder linkedFolder, boolean deleteParent, int deleteFlags) throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IFileStore linkDestLocation = ResourceTestUtil.getFileStore(this.tempDirectory);
        IFileStore linkDestFile = linkDestLocation.getChild(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInFileSystem(linkDestFile);
        Assertions.assertThat((Object)linkDestLocation).matches(exists, "exists");
        Assertions.assertThat((Object)linkDestFile).matches(exists, "exists");
        ResourceTestUtil.createInWorkspace((IResource)linkedFolder.getParent());
        String target = new File(linkDestLocation.toURI()).getAbsolutePath();
        IFile linkedFile = linkedFolder.getFile(linkDestFile.getName());
        String local = linkedFolder.getLocation().toOSString();
        this.createSymLink(target, local);
        ResourceTestUtil.assertExistsInFileSystem((IResource)linkedFolder);
        ResourceTestUtil.assertExistsInFileSystem((IResource)linkedFile);
        linkedFolder.getProject().refreshLocal(2, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)linkedFolder);
        ResourceTestUtil.assertExistsInWorkspace((IResource)linkedFile);
        if (deleteParent) {
            linkedFolder.getParent().delete(deleteFlags, ResourceTestUtil.createTestMonitor());
        } else {
            linkedFolder.delete(deleteFlags, ResourceTestUtil.createTestMonitor());
        }
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)linkedFolder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)linkedFile);
        Assertions.assertThat((Object)linkDestLocation).matches(exists, "exists");
        Assertions.assertThat((Object)linkDestFile).matches(exists, "exists");
    }

    @Test
    public void testDeleteLinkedFile() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        this.doTestDeleteLinkedFile(0);
    }

    @Test
    public void testDeleteLinkedFolder() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, false, 0);
    }

    @Test
    public void testDeleteLinkedResourceInProject() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, true, 0);
    }

    @Test
    public void testDeleteLinkedFileKeepHistory() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        this.doTestDeleteLinkedFile(2);
    }

    @Test
    public void testDeleteLinkedFolderParentKeepHistory() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder parent = project.getFolder("parent");
        IFolder linkedFolder = parent.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, true, 2);
    }

    @Test
    public void testDeleteLinkedFolderKeepHistory() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, false, 2);
    }

    @Test
    public void testDeleteLinkedResourceInProjectKeepHistory() throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, true, 2);
    }
}

