/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_079398 {
    @Test
    @Disabled(value="Bug 78398 needs to be fixed")
    public void testBug79398() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("myproject");
        IFile file1 = project.getFile("myFile.txt");
        IFile file2 = project.getFile("copyOfMyFile.txt");
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(4);
        description.setMaxFileStateSize(0x100000L);
        ResourcesPlugin.getWorkspace().setDescription(description);
        ResourceTestUtil.createInWorkspace(file1, ResourceTestUtil.createRandomString());
        int i = 0;
        while (i < 10) {
            file1.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
            ++i;
        }
        Object[] sourceStates = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])sourceStates).hasSize(10);
        file1.copy(file2.getFullPath(), true, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.assertExistsInWorkspace((IResource)file2);
        sourceStates = file1.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])sourceStates).hasSize(10);
        Object[] destinationStates = file2.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])destinationStates).hasSize(description.getMaxFileStates());
        int i2 = 0;
        while (i2 <= description.getMaxFileStates()) {
            file2.setContents(ResourceTestUtil.createRandomContentsStream(), 3, ResourceTestUtil.createTestMonitor());
            ++i2;
        }
        IHistoryStore history = ((Workspace)ResourcesPlugin.getWorkspace()).getFileSystemManager().getHistoryStore();
        history.clean(ResourceTestUtil.createTestMonitor());
        destinationStates = file2.getHistory(ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])destinationStates).hasSize(description.getMaxFileStates());
        sourceStates = file1.getHistory(ResourceTestUtil.createTestMonitor());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])sourceStates).hasSize(description.getMaxFileStates())).allMatch(IFileState::exists);
    }
}

