/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_126104 {
    @Test
    public void testBug(@TempDir Path tempDirectory) throws CoreException, IOException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("p1");
        IFile source = project.getFile("source");
        ResourceTestUtil.createInWorkspace((IResource)source);
        IFolder link = project.getFolder("link");
        IFileStore location = ResourceTestUtil.getFileStore(tempDirectory);
        link.createLink(location.toURI(), 16, ResourceTestUtil.createTestMonitor());
        IFile destination = link.getFile(source.getName());
        source.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)destination).matches(IResource::exists, "exists");
        ResourceTestUtil.removeFromWorkspace((IResource)destination);
        location.delete(0, ResourceTestUtil.createTestMonitor());
        source.move(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)source).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)destination).matches(IResource::exists, "exists");
    }
}

