/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_134364 {
    private IProject createOtherProject() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject other = workspace.getRoot().getProject("Other");
        IProjectDescription desc = workspace.newProjectDescription(other.getName());
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        other.create(desc, null);
        other.open(null);
        return other;
    }

    @Test
    public void test1() throws Exception {
        final IProject other = this.createOtherProject();
        final boolean[] done = new boolean[1];
        final RuntimeException[] failure = new RuntimeException[1];
        new Job("Reader-134364"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                try {
                    while (true) {
                        if (done[0]) {
                            return Status.OK_STATUS;
                        }
                        root.getProjects();
                        try {
                            other.members();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                }
                catch (RuntimeException e) {
                    failure[0] = e;
                    throw e;
                }
            }
        }.schedule();
        Job writer = new Job("Writer-134364"){

            public IStatus run(IProgressMonitor monitor) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("TestBug134364");
                int i = 0;
                while (i < 100) {
                    if (failure[0] != null) {
                        System.out.println("Failure: " + i);
                        break;
                    }
                    try {
                        project.create(null);
                        project.open(null);
                        project.touch(null);
                        project.delete(0, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return Status.OK_STATUS;
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        writer.schedule();
        writer.join();
        done[0] = true;
        if (failure[0] != null) {
            throw new AssertionError("1.0", failure[0]);
        }
    }
}

