/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.ClearMarkersBuilder;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_147232
implements IResourceChangeListener {
    int deltaSeenCount;
    IFile file;
    IProject project;

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta delta = event.getDelta().findMember(this.file.getFullPath());
        if (delta != null && delta.getKind() == 1) {
            ++this.deltaSeenCount;
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        ClearMarkersBuilder.pauseAfterBuild = true;
    }

    @AfterEach
    public void tearDown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ClearMarkersBuilder.pauseAfterBuild = false;
    }

    @Test
    public void testBug() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Bug_147232");
        this.file = this.project.getFile("file.txt");
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 25);
        ResourceTestUtil.setAutoBuilding(false);
        this.project.create(ResourceTestUtil.createTestMonitor());
        this.project.open(ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.updateProjectDescription(this.project).addingCommand("org.eclipse.core.tests.resources.clearmarkersbuilder").withTestBuilderId("builder").apply();
        ResourceTestUtil.setAutoBuilding(true);
        ResourceTestUtil.createInWorkspace((IResource)this.file);
        ResourceTestUtil.waitForBuild();
        Assertions.assertEquals((int)1, (int)this.deltaSeenCount);
    }
}

