/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_160251 {
    private static final Predicate<IResource> isSynchronizedDepthInfinite = resource -> resource.isSynchronized(2);
    @TempDir
    private Path tempDirectory;

    @Test
    public void testNonExistentDestination() throws CoreException, IOException {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("Important.txt");
        IFileStore destination = ResourceTestUtil.getFileStore(this.tempDirectory);
        IFileStore destinationFile = destination.getChild(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)source);
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        IProjectDescription description = source.getDescription();
        description.setLocationURI(destination.toURI());
        source.move(description, 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)source).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)source).matches(isSynchronizedDepthInfinite, "is synchronized");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)URIUtil.equals((URI)source.getLocationURI(), (URI)destination.toURI()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)URIUtil.equals((URI)sourceFile.getLocationURI(), (URI)destinationFile.toURI()));
    }

    @Test
    public void testEmptyDestination() throws CoreException, IOException {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("Important.txt");
        IFileStore destination = ResourceTestUtil.getFileStore(this.tempDirectory);
        IFileStore destinationFile = destination.getChild(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)source);
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        destination.mkdir(0, ResourceTestUtil.createTestMonitor());
        IProjectDescription description = source.getDescription();
        description.setLocationURI(destination.toURI());
        source.move(description, 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)source).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)source).matches(isSynchronizedDepthInfinite, "is synchronized");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)URIUtil.equals((URI)source.getLocationURI(), (URI)destination.toURI()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)URIUtil.equals((URI)sourceFile.getLocationURI(), (URI)destinationFile.toURI()));
    }

    @Test
    public void testOccupiedDestination() throws Exception {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFile sourceFile = source.getFile("Important.txt");
        IFileStore destination = ResourceTestUtil.getFileStore(this.tempDirectory);
        IFileStore destinationFile = destination.getChild(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)source);
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        destination.mkdir(0, ResourceTestUtil.createTestMonitor());
        ResourceTestUtil.createInFileSystem(destinationFile);
        IProjectDescription description = source.getDescription();
        description.setLocationURI(destination.toURI());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> source.move(description, 0, ResourceTestUtil.createTestMonitor()));
        Assertions.assertThat((Object)source).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)sourceFile).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)source).matches(isSynchronizedDepthInfinite, "is synchronized");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)URIUtil.equals((URI)source.getLocationURI(), (URI)destination.toURI()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)URIUtil.equals((URI)sourceFile.getLocationURI(), (URI)destinationFile.toURI()));
    }
}

