/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_165892 {
    @Test
    public void testCopyFile() throws CoreException {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("source");
        IFile destinationFile = sourceFolder.getFile("destination");
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        String sourceValue = "SourceValue";
        QualifiedName name = new QualifiedName("Bug_165892", "Property");
        sourceFile.setPersistentProperty(name, "SourceValue");
        sourceFile.copy(destinationFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFile.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)destinationFile.getPersistentProperty(name));
        String destinationValue = "DestinationValue";
        destinationFile.setPersistentProperty(name, "DestinationValue");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFile.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DestinationValue", (Object)destinationFile.getPersistentProperty(name));
    }

    @Test
    public void testCopyFileHistory() throws CoreException {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("source");
        IFile destinationFile = sourceFolder.getFile("destination");
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        sourceFile.setContents(ResourceTestUtil.createRandomContentsStream(), 2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])sourceFile.getHistory(ResourceTestUtil.createTestMonitor())).hasSize(1);
        sourceFile.copy(destinationFile.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])sourceFile.getHistory(ResourceTestUtil.createTestMonitor())).hasSize(1);
        Assertions.assertThat((Object[])destinationFile.getHistory(ResourceTestUtil.createTestMonitor())).hasSize(1);
        destinationFile.setContents(ResourceTestUtil.createRandomContentsStream(), 2, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object[])sourceFile.getHistory(ResourceTestUtil.createTestMonitor())).hasSize(1);
        Assertions.assertThat((Object[])destinationFile.getHistory(ResourceTestUtil.createTestMonitor())).hasSize(2);
    }

    @Test
    public void testCopyFolder() throws CoreException {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("project");
        IFolder sourceFolder = source.getFolder("source");
        IFile sourceFile = sourceFolder.getFile("Important.txt");
        IFolder destinationFolder = source.getFolder("destination");
        IFile destinationFile = destinationFolder.getFile(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        String sourceValue = "SourceValue";
        QualifiedName name = new QualifiedName("Bug_165892", "Property");
        source.setPersistentProperty(name, "SourceValue");
        sourceFolder.setPersistentProperty(name, "SourceValue");
        sourceFile.setPersistentProperty(name, "SourceValue");
        sourceFolder.copy(destinationFolder.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)source.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFile.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)destinationFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)destinationFile.getPersistentProperty(name));
        String destinationValue = "DestinationValue";
        destinationFolder.setPersistentProperty(name, "DestinationValue");
        destinationFile.setPersistentProperty(name, "DestinationValue");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)source.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFile.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DestinationValue", (Object)destinationFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DestinationValue", (Object)destinationFile.getPersistentProperty(name));
    }

    @Test
    public void testCopyProject() throws CoreException {
        IProject source = ResourcesPlugin.getWorkspace().getRoot().getProject("source");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("Important.txt");
        IProject destination = ResourcesPlugin.getWorkspace().getRoot().getProject("destination");
        IFolder destinationFolder = destination.getFolder(sourceFolder.getName());
        IFile destinationFile = destinationFolder.getFile(sourceFile.getName());
        ResourceTestUtil.createInWorkspace((IResource)sourceFile);
        String sourceValue = "SourceValue";
        QualifiedName name = new QualifiedName("Bug_165892", "Property");
        source.setPersistentProperty(name, "SourceValue");
        sourceFolder.setPersistentProperty(name, "SourceValue");
        sourceFile.setPersistentProperty(name, "SourceValue");
        source.copy(destination.getFullPath(), 0, ResourceTestUtil.createTestMonitor());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)source.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFile.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)destination.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)destinationFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)destinationFile.getPersistentProperty(name));
        String destinationValue = "DestinationValue";
        destination.setPersistentProperty(name, "DestinationValue");
        destinationFolder.setPersistentProperty(name, "DestinationValue");
        destinationFile.setPersistentProperty(name, "DestinationValue");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)source.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SourceValue", (Object)sourceFile.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DestinationValue", (Object)destination.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DestinationValue", (Object)destinationFolder.getPersistentProperty(name));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"DestinationValue", (Object)destinationFile.getPersistentProperty(name));
    }
}

