/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_185247_LinuxTests {
    private String testMethodName;
    @TempDir
    private Path tempDirectory;
    private IPath testCasesLocation;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        Assume.assumeTrue((String)"only relevant on Linux", (boolean)Platform.OS.isLinux());
        this.testMethodName = ((Method)testInfo.getTestMethod().get()).getName();
        IPath randomLocation = IPath.fromPath((Path)this.tempDirectory);
        this.testCasesLocation = randomLocation.append("bug185247LinuxTests");
        Assertions.assertTrue((boolean)this.testCasesLocation.toFile().mkdirs(), (String)("failed to create test location: " + String.valueOf(this.testCasesLocation)));
        this.extractTestCasesArchive(this.testCasesLocation);
    }

    private void extractTestCasesArchive(IPath outputLocation) throws Exception {
        URL testCasesArchive = Platform.getBundle((String)"org.eclipse.core.tests.resources").getEntry("resources/bug185247/bug185247_LinuxTests.zip");
        URL archiveLocation = FileLocator.resolve((URL)testCasesArchive);
        File archive = URIUtil.toFile((URI)archiveLocation.toURI());
        Assertions.assertNotNull((Object)archive, (String)"cannot find archive with test cases");
        Bug_185247_LinuxTests.unzip(archive, outputLocation.toFile());
    }

    @Test
    public void test1_trivial() throws Exception {
        this.runProjectTestCase();
    }

    @Test
    public void test2_mutual() throws Exception {
        this.runProjectTestCase();
    }

    @Test
    public void test3_outside_tree() throws Exception {
        this.runProjectTestCase();
    }

    @Test
    public void test5_transitive_mutual() throws Exception {
        this.runProjectTestCase();
    }

    @Test
    public void test6_nonrecursive() throws Exception {
        this.runProjectTestCase();
    }

    private void runProjectTestCase() throws Exception {
        this.importProjectAndRefresh(this.testMethodName);
    }

    private void importProjectAndRefresh(String projectName) throws Exception {
        IProject project = this.importTestProject(projectName);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
    }

    private IProject importTestProject(String projectName) throws Exception {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName(projectName);
        String projectRoot = String.join((CharSequence)File.separator, this.testCasesLocation.toOSString(), "bug185247", projectName);
        projectDescription.setLocationURI(URI.create(projectRoot));
        testProject.create((IProjectDescription)projectDescription, ResourceTestUtil.createTestMonitor());
        testProject.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)testProject.isAccessible(), (String)("expected project to be open: " + projectName));
        return testProject;
    }

    private static void unzip(File archive, File outputDirectory) throws Exception {
        String[] command = new String[]{"unzip", archive.toString(), "-d", outputDirectory.toString()};
        Bug_185247_LinuxTests.executeCommand(command, outputDirectory);
    }

    private static void executeCommand(String[] command, File outputDirectory) throws Exception {
        Assertions.assertTrue((boolean)outputDirectory.exists(), (String)("output directory does not exist: " + String.valueOf(outputDirectory)));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandOutputFile = new File(outputDirectory, "commandOutput.txt");
        if (!commandOutputFile.exists()) {
            Assertions.assertTrue((boolean)commandOutputFile.createNewFile(), (String)"failed to create standard output and error file for unzip command");
        }
        processBuilder.redirectOutput(commandOutputFile);
        processBuilder.redirectError(commandOutputFile);
        Process process = processBuilder.start();
        int commandExitCode = process.waitFor();
        String output = Bug_185247_LinuxTests.formatCommandOutput(command, commandOutputFile);
        Assertions.assertTrue((boolean)commandOutputFile.delete(), (String)("Failed to delete command output file. " + output));
        Assertions.assertEquals((int)0, (int)commandExitCode, (String)("Failed to execute commmand. " + output));
    }

    private static String formatCommandOutput(String[] command, File commandOutputFile) throws IOException {
        Path commandOutputPath = Paths.get(commandOutputFile.getAbsolutePath(), new String[0]);
        List<String> commandOutputLines = Files.readAllLines(commandOutputPath);
        List<String> commandOutputHeader = Arrays.asList("Command:", Arrays.toString(command), "Output:");
        ArrayList<String> commandToString = new ArrayList<String>();
        commandToString.addAll(commandOutputHeader);
        commandToString.addAll(commandOutputLines);
        String formattedOutput = String.join((CharSequence)System.lineSeparator(), commandToString);
        return formattedOutput;
    }
}

