/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Path;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_185247_recursiveLinks {
    @TempDir
    private Path tempDirectory;
    private String testMethodName;

    @BeforeEach
    public void requireCanCreateSymlinks(TestInfo testInfo) throws IOException {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
        this.testMethodName = ((Method)testInfo.getTestMethod().get()).getName();
    }

    @Test
    public void test1_linkCurrentDirectory() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> this.createSymlink(directory, "link_current", "./");
        this.runTest(createSymlinks);
    }

    @Test
    public void test2_linkParentDirectory() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> this.createSymlink(directory, "link_parent", "../");
        this.runTest(createSymlinks);
    }

    @Test
    public void test3_linkGrandparentDirectory() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> {
            File subdirectory = new File(directory, "subdirectory");
            Bug_185247_recursiveLinks.createDirectory(subdirectory);
            this.createSymlink(subdirectory, "link_grandparent", "../../");
        };
        this.runTest(createSymlinks);
    }

    @Test
    public void test4_linkParentDirectoryTwice() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> {
            String[] subdirectoryNames;
            String[] stringArray = subdirectoryNames = new String[]{"subdirectory1", "subdirectory2"};
            int n = subdirectoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subdirectoryName = stringArray[n2];
                File subdirectory = new File(directory, subdirectoryName);
                Bug_185247_recursiveLinks.createDirectory(subdirectory);
                this.createSymlink(subdirectory, "link_parent", "../../");
                ++n2;
            }
        };
        this.runTest(createSymlinks);
    }

    @Test
    public void test5_linkParentDirectoyTwiceWithAbsolutePath() throws Exception {
        CreateTestProjectStructure createSymlinks = directory -> {
            String[] subdirectoryNames;
            String[] stringArray = subdirectoryNames = new String[]{"subdirectory1", "subdirectory2"};
            int n = subdirectoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subdirectoryName = stringArray[n2];
                File subdirectory = new File(directory, subdirectoryName);
                Bug_185247_recursiveLinks.createDirectory(subdirectory);
                this.createSymlink(subdirectory, "link_parent", directory.getAbsolutePath());
                ++n2;
            }
        };
        this.runTest(createSymlinks);
    }

    private void runTest(CreateTestProjectStructure createSymlinks) throws MalformedURLException, Exception {
        String projectName = this.testMethodName;
        IPath testRoot = IPath.fromPath((Path)this.tempDirectory);
        IPath projectRoot = testRoot.append("bug185247recursive").append(projectName);
        File directory = projectRoot.append("directory").toFile();
        Bug_185247_recursiveLinks.createDirectory(directory);
        createSymlinks.accept(directory);
        URI projectRootLocation = URIUtil.toURI((IPath)projectRoot);
        this.importProjectAndRefresh(projectName, projectRootLocation);
    }

    private static void createDirectory(File directory) {
        Assertions.assertTrue((boolean)directory.mkdirs(), (String)("failed to create test directory: " + String.valueOf(directory)));
    }

    void createSymlink(File directory, String linkName, String linkTarget) throws IOException {
        Assertions.assertTrue((boolean)FileSystemHelper.canCreateSymLinks(), (String)"symlinks not supported by platform");
        boolean isDir = true;
        FileSystemHelper.createSymLink((File)directory, (String)linkName, (String)linkTarget, (boolean)isDir);
    }

    private void importProjectAndRefresh(String projectName, URI projectRootLocation) throws Exception {
        IProject project = this.importTestProject(projectName, projectRootLocation);
        project.refreshLocal(2, ResourceTestUtil.createTestMonitor());
    }

    private IProject importTestProject(String projectName, URI projectRootLocation) throws Exception {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName(projectName);
        projectDescription.setLocationURI(projectRootLocation);
        testProject.create((IProjectDescription)projectDescription, ResourceTestUtil.createTestMonitor());
        testProject.open(ResourceTestUtil.createTestMonitor());
        Assertions.assertTrue((boolean)testProject.isAccessible(), (String)("expected project to be open: " + projectName));
        return testProject;
    }

    static interface CreateTestProjectStructure {
        public void accept(File var1) throws Exception;
    }
}

