/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_226264 {
    @Test
    public void testBug() throws CoreException, InterruptedException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        project1.create(null);
        project1.open(null);
        final IProject project2 = workspace.getRoot().getProject("Project2");
        project2.create(null);
        project2.open(null);
        WorkspaceJob job = new WorkspaceJob("job"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project2.delete(true, null);
                return Status.OK_STATUS;
            }
        };
        IResourceChangeListener projectDeletingChangeListener = event -> {
            if (event.getResource() == project1) {
                job.schedule();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        try {
            workspace.addResourceChangeListener(projectDeletingChangeListener, 4);
            project1.delete(true, null);
            job.join();
        }
        finally {
            workspace.removeResourceChangeListener(projectDeletingChangeListener);
        }
        Assertions.assertThat((Object)job.getResult()).matches(IStatus::isOK, "is okay");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)project1);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)project2);
    }
}

