/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.util.function.Predicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_231301 {
    @Test
    public void testBug() throws CoreException, InterruptedException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        project1.create(null);
        project1.open(null);
        final IProject project2 = workspace.getRoot().getProject("Project2");
        project2.create(null);
        project2.open(null);
        WorkspaceJob job = new WorkspaceJob("job"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project2.close(null);
                return Status.OK_STATUS;
            }
        };
        IResourceChangeListener projectClosingChangeListener = event -> {
            if (event.getResource() == project1) {
                job.schedule();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        try {
            workspace.addResourceChangeListener(projectClosingChangeListener, 2);
            project1.close(ResourceTestUtil.createTestMonitor());
            job.join();
        }
        finally {
            workspace.removeResourceChangeListener(projectClosingChangeListener);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)job.getResult().isOK()).withFailMessage(job.getResult().toString(), new Object[0])).isTrue();
        Assertions.assertThat((Object)project1).matches(Predicate.not(IProject::isOpen), "is not open");
        Assertions.assertThat((Object)project2).matches(Predicate.not(IProject::isOpen), "is not open");
    }
}

