/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_233939 {
    @BeforeEach
    public void requireCanCreateSymlinks() throws IOException {
        Assume.assumeTrue((String)"only relevant for platforms supporting symbolic links", (boolean)FileSystemHelper.canCreateSymLinks());
    }

    protected void symLinkAndRefresh(IContainer container, String linkName, IPath linkTarget) throws CoreException, IOException {
        FileSystemHelper.createSymLink((File)container.getLocation().toFile(), (String)linkName, (String)linkTarget.toOSString(), (boolean)false);
        container.refreshLocal(2, ResourceTestUtil.createTestMonitor());
        IResource theLink = container.findMember(linkName);
        ResourceTestUtil.assertExistsInWorkspace(theLink);
        Assertions.assertThat((Object)theLink).matches(it -> it.getResourceAttributes().isSymbolicLink(), "is symbolic link");
    }

    protected boolean isSameLocation(IFile file, IFileStore store) {
        URI loc1 = FileUtil.canonicalURI((URI)file.getLocationURI());
        URI loc2 = FileUtil.canonicalURI((URI)store.toURI());
        return loc1.equals(loc2);
    }

    @Test
    public void testBug(@TempDir Path tempDirectory) throws Exception {
        String fileName = "file.txt";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(ResourceTestUtil.createUniqueString());
        IFile file = project.getFile(fileName);
        project.create(ResourceTestUtil.createTestMonitor());
        project.open(ResourceTestUtil.createTestMonitor());
        IFileStore tempFileStore = ResourceTestUtil.getFileStore(tempDirectory).getChild(fileName);
        ResourceTestUtil.createInFileSystem(tempFileStore);
        IPath fileInTempDirPath = URIUtil.toPath((URI)tempFileStore.toURI());
        this.symLinkAndRefresh((IContainer)project, fileName, fileInTempDirPath);
        Object[] files = root.findFilesForLocationURI(file.getLocationURI());
        Assertions.assertThat((Object[])files).containsExactly((Object[])new IFile[]{file});
    }

    @Test
    public void testMultipleLinksToFolder(@TempDir Path tempDirectory) throws Exception {
        IFileStore tempStore = ResourceTestUtil.getFileStore(tempDirectory);
        ResourceTestUtil.createInFileSystem(tempStore.getChild("foo.txt"));
        IPath tempFolderPath = URIUtil.toPath((URI)tempStore.toURI());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectA = root.getProject(ResourceTestUtil.createUniqueString());
        IProject projectB = root.getProject(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInWorkspace((IResource)projectA);
        ResourceTestUtil.createInWorkspace((IResource)projectB);
        this.symLinkAndRefresh((IContainer)projectA, "folderA", tempFolderPath);
        this.symLinkAndRefresh((IContainer)projectB, "folderB", tempFolderPath);
    }
}

