/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.nio.file.Path;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_264182 {
    IProject project;
    IFile dotProject;

    @BeforeEach
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
        this.dotProject = this.project.getFile(".project");
        ResourceTestUtil.setReadOnly((IResource)this.dotProject, true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        ResourceTestUtil.setReadOnly((IResource)this.dotProject, false);
    }

    @Test
    public void testBug(@TempDir Path tempDirectory) throws Exception {
        IFile file = this.project.getFile(ResourceTestUtil.createUniqueString());
        IFileStore tempFileStore = ResourceTestUtil.getFileStore(tempDirectory).getChild("temp");
        ResourceTestUtil.createInFileSystem(tempFileStore);
        Assertions.assertThrows(CoreException.class, () -> file.createLink(tempFileStore.toURI(), 0, (IProgressMonitor)new NullProgressMonitor()));
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
    }
}

