/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_265810 {
    @TempDir
    private Path tempDirectory;
    List<IResourceDelta> resourceDeltas = new ArrayList<IResourceDelta>();

    public IPath createFolderAtRandomLocation() throws IOException {
        IPath path = IPath.fromPath((Path)this.tempDirectory).append(ResourceTestUtil.createUniqueString());
        path.toFile().createNewFile();
        return path;
    }

    @Test
    public void testBug() throws Throwable {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceTestUtil.createUniqueString());
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        IFile file = project.getFile(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file.createLink(this.createFolderAtRandomLocation(), 0, (IProgressMonitor)new NullProgressMonitor());
        file.setContents(ResourceTestUtil.createInputStream("contents for a file"), 0, (IProgressMonitor)new NullProgressMonitor());
        byte[] dotProject1 = this.storeDotProject(project);
        IFile newFile = project.getFile("newFile");
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)newFile);
        newFile.createLink(this.createFolderAtRandomLocation(), 0, (IProgressMonitor)new NullProgressMonitor());
        byte[] dotProject2 = this.storeDotProject(project);
        AtomicReference<Executable> listenerInMainThreadCallback = new AtomicReference<Executable>(() -> {});
        IResourceChangeListener listener = event -> {
            try {
                event.getDelta().accept(delta -> {
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile && !resource.getName().equals(".project")) {
                        this.addToResourceDelta(delta);
                    }
                    return delta.getAffectedChildren().length > 0;
                });
            }
            catch (CoreException e) {
                listenerInMainThreadCallback.set(() -> {
                    throw e;
                });
            }
        };
        try {
            this.resourceDeltas = new ArrayList<IResourceDelta>();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
            this.restoreDotProject(project, dotProject1);
            Assertions.assertThat(this.resourceDeltas).hasSize(1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)newFile, (Object)this.resourceDeltas.get(0).getResource());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.resourceDeltas.get(0).getKind());
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().execute();
        newFile.create(ResourceTestUtil.createInputStream("content"), 0, (IProgressMonitor)new NullProgressMonitor());
        try {
            this.resourceDeltas = new ArrayList<IResourceDelta>();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
            this.restoreDotProject(project, dotProject2);
            Assertions.assertThat(this.resourceDeltas).hasSize(1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)newFile, (Object)this.resourceDeltas.get(0).getResource());
            org.junit.jupiter.api.Assertions.assertEquals((int)262144, (int)(this.resourceDeltas.get(0).getFlags() & 0x40000));
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        listenerInMainThreadCallback.get().execute();
    }

    private byte[] storeDotProject(IProject project) throws Exception {
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        byte[] doProject = new byte[]{};
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream iS = project.getFile(".project").getContents();){
            bytesRead = iS.read(buffer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        doProject = new byte[bytesRead];
        System.arraycopy(buffer, 0, doProject, 0, bytesRead);
        return doProject;
    }

    private void restoreDotProject(IProject project, byte[] dotProject) throws CoreException {
        project.getFile(".project").setContents((InputStream)new ByteArrayInputStream(dotProject), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    boolean addToResourceDelta(IResourceDelta delta) {
        return this.resourceDeltas.add(delta);
    }
}

