/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_297635 {
    @BeforeEach
    public void setUp() throws Exception {
        BundleWithSaveParticipant.install();
        this.saveFull();
    }

    @AfterEach
    public void tearDown() throws BundleException {
        BundleWithSaveParticipant.uninstall();
    }

    @Test
    public void testCleanSaveStateBySaveParticipantOnSnapshotSave() throws Exception {
        this.executeWithSaveManagerSpy(saveManagerSpy -> {
            try {
                this.saveSnapshot((SaveManager)saveManagerSpy);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ((SaveManager)Mockito.verify((Object)saveManagerSpy)).forgetSavedTree(BundleWithSaveParticipant.getBundleName());
        });
    }

    private void saveFull() throws CoreException {
        ResourcesPlugin.getWorkspace().save(true, ResourceTestUtil.createTestMonitor());
    }

    private void saveSnapshot(SaveManager saveManager) throws CoreException {
        saveManager.save(2, true, null, ResourceTestUtil.createTestMonitor());
    }

    private void executeWithSaveManagerSpy(Consumer<SaveManager> executeOnSpySaveManager) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String saveManagerFieldName = "saveManager";
        SaveManager originalSaveManager = (SaveManager)Bug_297635.getField(workspace, saveManagerFieldName);
        SaveManager spySaveManager = (SaveManager)Mockito.spy((Object)originalSaveManager);
        try {
            Bug_297635.setField(workspace, saveManagerFieldName, spySaveManager);
            executeOnSpySaveManager.accept(spySaveManager);
        }
        finally {
            Bug_297635.setField(workspace, saveManagerFieldName, originalSaveManager);
        }
    }

    private static Object getField(Object object, String fieldName) throws Exception {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    private static void setField(Object object, String fieldName, Object value) throws Exception {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, value);
    }

    private static final class BundleWithSaveParticipant {
        private static String TEST_BUNDLE_LOCATION = "content/bundle01";
        private static Bundle bundle;
        private static ISaveParticipant saveParticipant;

        static {
            saveParticipant = new ISaveParticipant(){

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) {
                    context.needDelta();
                    context.needSaveNumber();
                }

                public void rollback(ISaveContext context) {
                }

                public void saving(ISaveContext context) {
                }
            };
        }

        private BundleWithSaveParticipant() {
        }

        public static String getBundleName() {
            if (bundle == null) {
                throw new IllegalStateException("Bundle has not been installed");
            }
            return bundle.getSymbolicName();
        }

        public static void uninstall() throws BundleException {
            if (bundle != null) {
                bundle.uninstall();
            }
        }

        public static void install() throws Exception {
            bundle = BundleTestingHelper.installBundle((String)"", (BundleContext)BundleWithSaveParticipant.getContext(), (String)("Plugin_Testing/" + TEST_BUNDLE_LOCATION));
            BundleTestingHelper.resolveBundles((BundleContext)BundleWithSaveParticipant.getContext(), (Bundle[])new Bundle[]{bundle});
            bundle.start(1);
            BundleWithSaveParticipant.registerSaveParticipant(bundle);
        }

        private static BundleContext getContext() {
            return Platform.getBundle((String)"org.eclipse.core.tests.resources").getBundleContext();
        }

        private static void registerSaveParticipant(Bundle saveParticipantsBundle) throws CoreException {
            ResourcesPlugin.getWorkspace().addSaveParticipant(saveParticipantsBundle.getSymbolicName(), saveParticipant);
        }
    }
}

