/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.InputStream;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_303517 {
    private static final Predicate<IResource> isSynchronizedDepthInfinite = resource -> resource.isSynchronized(2);
    private static final Predicate<IResource> isSynchronizedDepthOne = resource -> resource.isSynchronized(1);
    private final String[] resourcePaths = new String[]{"/", "/Bug303517/", "/Bug303517/Folder/", "/Bug303517/Folder/Resource"};
    private boolean originalRefreshSetting;

    @BeforeEach
    public void setUp() throws Exception {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        this.originalRefreshSetting = prefs.getBoolean("refresh.enabled", false);
        prefs.putBoolean("refresh.enabled", true);
        prefs.putBoolean("refresh.lightweight.enabled", true);
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.resourcePaths);
        ResourceTestUtil.createInWorkspace(resources);
    }

    @AfterEach
    public void tearDown() throws Exception {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.enabled", this.originalRefreshSetting);
        prefs.putBoolean("refresh.lightweight.enabled", false);
    }

    @Test
    public void testExists() throws Exception {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)this.resourcePaths[this.resourcePaths.length - 1]));
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthOne, "is synchronized");
        f.getLocation().toFile().delete();
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                InputStream in = f.getContents();
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)f).matches(Predicate.not(IResource::exists), "not exists");
    }

    @Test
    public void testGetContents() throws Exception {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)this.resourcePaths[this.resourcePaths.length - 1]));
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthOne, "is synchronized");
        ResourceTestUtil.touchInFilesystem((IResource)f);
        CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                InputStream in = f.getContents(false);
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)274, (int)exception.getStatus().getCode());
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            InputStream in = f.getContents(false);
            if (in != null) {
                in.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetContentsTrue() throws Exception {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)this.resourcePaths[this.resourcePaths.length - 1]));
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthOne, "is synchronized");
        ResourceTestUtil.touchInFilesystem((IResource)f);
        f.readAllBytes();
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        f.readAllBytes();
        f.getLocation().toFile().delete();
        CoreException exception = (CoreException)org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                InputStream in = f.getContents(true);
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)368, (int)exception.getStatus().getCode());
    }

    @Test
    public void testIsSynchronized() throws Exception {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)this.resourcePaths[this.resourcePaths.length - 1]));
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthOne, "is synchronized");
        ResourceTestUtil.touchInFilesystem((IResource)f);
        Assertions.assertThat((Object)f).matches(Predicate.not(isSynchronizedDepthOne), "is not synchronized");
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthOne, "is synchronized");
    }

    @Test
    public void testChangeResourceGender() throws Exception {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)this.resourcePaths[this.resourcePaths.length - 1]));
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthOne, "is synchronized");
        File osResource = f.getLocation().toFile();
        osResource.delete();
        osResource.mkdir();
        Assertions.assertThat((File)osResource).matches(File::exists, "exists");
        File osChild = new File(osResource, "child");
        osChild.createNewFile();
        Assertions.assertThat((File)osChild).matches(File::exists, "exists");
        Assertions.assertThat((Object)f).matches(Predicate.not(isSynchronizedDepthOne), "is not synchronized");
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_REFRESH);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, ResourceTestUtil.createTestMonitor());
        Assertions.assertThat((Object)f).matches(Predicate.not(IResource::exists), "not exists");
        Assertions.assertThat((Object)f).matches(Predicate.not(isSynchronizedDepthOne), "is not synchronized");
        f = ResourcesPlugin.getWorkspace().getRoot().getFolder(IPath.fromOSString((String)this.resourcePaths[this.resourcePaths.length - 1]));
        Assertions.assertThat((Object)f).matches(IResource::exists, "exists");
        Assertions.assertThat((Object)f).matches(isSynchronizedDepthInfinite, "is synchronized");
    }
}

