/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.util.WorkspaceResetExtension;
import org.junit.Assume;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={WorkspaceResetExtension.class})
public class Bug_329836 {
    @Test
    public void testBug(@TempDir Path tempDirectory) throws Exception {
        Assume.assumeTrue((String)"only relevant on Mac", (boolean)Platform.OS.isMac());
        IFileStore fileStore = ResourceTestUtil.getFileStore(tempDirectory).getChild(ResourceTestUtil.createUniqueString());
        ResourceTestUtil.createInFileSystem(fileStore);
        IFileInfo info = fileStore.fetchInfo();
        info.setAttribute(2, true);
        fileStore.putInfo(info, 1024, ResourceTestUtil.createTestMonitor());
        info = fileStore.fetchInfo();
        Assertions.assertThat((Comparable)info).matches(it -> it.getAttribute(2), "is read only");
        if (ResourceTestUtil.isAttributeSupported(0x200000)) {
            Assertions.assertThat((Comparable)info).matches(it -> it.getAttribute(0x200000), "is immutable");
        }
        info.setAttribute(2, false);
        fileStore.putInfo(info, 1024, ResourceTestUtil.createTestMonitor());
        info = fileStore.fetchInfo();
        Assertions.assertThat((Comparable)info).matches(it -> !it.getAttribute(2), "is not read only");
        if (ResourceTestUtil.isAttributeSupported(0x200000)) {
            Assertions.assertThat((Comparable)info).matches(it -> !it.getAttribute(0x200000), "is not immutable");
        }
    }
}

